/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.subsystems.jca.ArchiveValidationAdd;
import org.jboss.as.connector.subsystems.jca.Attribute;
import org.jboss.as.connector.subsystems.jca.BeanValidationAdd;
import org.jboss.as.connector.subsystems.jca.BootstrapContextAdd;
import org.jboss.as.connector.subsystems.jca.CachedConnectionManagerAdd;
import org.jboss.as.connector.subsystems.jca.Element;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemAdd;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemProviders;
import org.jboss.as.connector.subsystems.jca.Namespace;
import org.jboss.as.connector.subsystems.jca.WorkManagerAdd;
import org.jboss.as.connector.subsystems.resourceadapters.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.BoundedQueueThreadPoolRemove;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JcaExtension
implements Extension {
    public static String SUBSYSTEM_NAME = "jca";

    public void initialize(ExtensionContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("Initializing Connector Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(JcaSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)JcaSubsystemAdd.INSTANCE, JcaSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, JcaSubsystemProviders.SUBSYSTEM_REMOVE_DESC, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration archiveValidation = registration.registerSubModel(PathElement.pathElement((String)"archive-validation", (String)"archive-validation"), JcaSubsystemProviders.ARCHIVE_VALIDATION_DESC);
        archiveValidation.registerOperationHandler("add", (OperationStepHandler)ArchiveValidationAdd.INSTANCE, JcaSubsystemProviders.ADD_ARCHIVE_VALIDATION_DESC, false);
        archiveValidation.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, JcaSubsystemProviders.REMOVE_ARCHIVE_VALIDATION_DESC, false);
        for (ArchiveValidationAdd.ArchiveValidationParameters parameter : ArchiveValidationAdd.ArchiveValidationParameters.values()) {
            archiveValidation.registerReadWriteAttribute(parameter.getAttribute().getName(), null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(), AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration beanValidation = registration.registerSubModel(PathElement.pathElement((String)"bean-validation", (String)"bean-validation"), JcaSubsystemProviders.BEAN_VALIDATION_DESC);
        beanValidation.registerOperationHandler("add", (OperationStepHandler)BeanValidationAdd.INSTANCE, JcaSubsystemProviders.ADD_BEAN_VALIDATION_DESC, false);
        beanValidation.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, JcaSubsystemProviders.REMOVE_BEAN_VALIDATION_DESC, false);
        for (BeanValidationAdd.BeanValidationParameters parameter : BeanValidationAdd.BeanValidationParameters.values()) {
            beanValidation.registerReadWriteAttribute(parameter.getAttribute().getName(), null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(), AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration cachedConnectionManager = registration.registerSubModel(PathElement.pathElement((String)"cached-connection-manager", (String)"cached-connection-manager"), JcaSubsystemProviders.CACHED_CONNECTION_MANAGER_DESC);
        cachedConnectionManager.registerOperationHandler("add", (OperationStepHandler)CachedConnectionManagerAdd.INSTANCE, JcaSubsystemProviders.ADD_CACHED_CONNECTION_MANAGER_DESC, false);
        cachedConnectionManager.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, JcaSubsystemProviders.REMOVE_CACHED_CONNECTION_MANAGER_DESC, false);
        for (CachedConnectionManagerAdd.CcmParameters parameter : CachedConnectionManagerAdd.CcmParameters.values()) {
            cachedConnectionManager.registerReadWriteAttribute(parameter.getAttribute().getName(), null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(), AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration workManager = registration.registerSubModel(PathElement.pathElement((String)"workmanager"), JcaSubsystemProviders.WORKMANAGER_DESC);
        workManager.registerOperationHandler("add", (OperationStepHandler)WorkManagerAdd.INSTANCE, JcaSubsystemProviders.ADD_WORKMANAGER_DESC, false);
        workManager.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, JcaSubsystemProviders.REMOVE_WORKMANAGER_DESC, false);
        for (WorkManagerAdd.WmParameters parameter : WorkManagerAdd.WmParameters.values()) {
            workManager.registerReadWriteAttribute(parameter.getAttribute().getName(), null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(), AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration shortRunning = workManager.registerSubModel(PathElement.pathElement((String)"short-running-threads"), ThreadsSubsystemProviders.BOUNDED_QUEUE_THREAD_POOL_DESC);
        shortRunning.registerOperationHandler("add", (OperationStepHandler)BoundedQueueThreadPoolAdd.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolAdd.INSTANCE, false);
        shortRunning.registerOperationHandler("remove", (OperationStepHandler)BoundedQueueThreadPoolRemove.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolRemove.INSTANCE, false);
        ManagementResourceRegistration longRunning = workManager.registerSubModel(PathElement.pathElement((String)"long-running-threads"), ThreadsSubsystemProviders.BOUNDED_QUEUE_THREAD_POOL_DESC);
        longRunning.registerOperationHandler("add", (OperationStepHandler)BoundedQueueThreadPoolAdd.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolAdd.INSTANCE, false);
        longRunning.registerOperationHandler("remove", (OperationStepHandler)BoundedQueueThreadPoolRemove.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolRemove.INSTANCE, false);
        ManagementResourceRegistration bootstrapContext = registration.registerSubModel(PathElement.pathElement((String)"bootstrap-context"), JcaSubsystemProviders.BOOTSTRAP_CONTEXT_DESC);
        bootstrapContext.registerOperationHandler("add", (OperationStepHandler)BootstrapContextAdd.INSTANCE, JcaSubsystemProviders.ADD_BOOTSTRAP_CONTEXT_DESC, false);
        bootstrapContext.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, JcaSubsystemProviders.REMOVE_BOOTSTRAP_CONTEXT_DESC, false);
        for (BootstrapContextAdd.BootstrapCtxParameters parameter : BootstrapContextAdd.BootstrapCtxParameters.values()) {
            bootstrapContext.registerReadWriteAttribute(parameter.getAttribute().getName(), null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(), AttributeAccess.Storage.CONFIGURATION);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)ConnectorSubsystemParser.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.JCA_1_0.getUriString(), (XMLElementReader)ConnectorSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(Namespace.JCA_1_1.getUriString(), (XMLElementReader)ConnectorSubsystemParser.INSTANCE);
    }

    private static ModelNode createEmptyAddOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", "jca");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        return subsystem;
    }

    static final class ConnectorSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final ConnectorSubsystemParser INSTANCE = new ConnectorSubsystemParser();

        ConnectorSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            this.writeArchiveValidation(writer, node);
            this.writeBeanValidation(writer, node);
            this.writeWorkManagers(writer, node);
            this.writeBootstrapContexts(writer, node);
            this.writeCachedConnectionManager(writer, node);
            writer.writeEndElement();
        }

        private void writeArchiveValidation(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("archive-validation")) {
                ModelNode node = parentNode.get("archive-validation").get("archive-validation");
                if (ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().isMarshallable(node) || ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().isMarshallable(node) || ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().isMarshallable(node)) {
                    writer.writeEmptyElement(Element.ARCHIVE_VALIDATION.getLocalName());
                    ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                }
            }
        }

        private void writeBeanValidation(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("bean-validation")) {
                ModelNode node = parentNode.get("bean-validation").get("bean-validation");
                if (BeanValidationAdd.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().isMarshallable(node)) {
                    writer.writeEmptyElement(Element.BEAN_VALIDATION.getLocalName());
                    BeanValidationAdd.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                }
            }
        }

        private void writeCachedConnectionManager(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("cached-connection-manager")) {
                ModelNode node = parentNode.get("cached-connection-manager").get("cached-connection-manager");
                if (CachedConnectionManagerAdd.CcmParameters.DEBUG.getAttribute().isMarshallable(node) || CachedConnectionManagerAdd.CcmParameters.ERROR.getAttribute().isMarshallable(node)) {
                    writer.writeEmptyElement(Element.CACHED_CONNECTION_MANAGER.getLocalName());
                    CachedConnectionManagerAdd.CcmParameters.DEBUG.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    CachedConnectionManagerAdd.CcmParameters.ERROR.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                }
            }
        }

        private void writeWorkManagers(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("workmanager") && parentNode.get("workmanager").asList().size() != 0) {
                for (Property property : parentNode.get("workmanager").asPropertyList()) {
                    if ("default".equals(property.getValue().get("name").asString())) {
                        writer.writeStartElement(Element.DEFAULT_WORKMANAGER.getLocalName());
                    } else {
                        writer.writeStartElement(Element.WORKMANAGER.getLocalName());
                        WorkManagerAdd.WmParameters.NAME.getAttribute().marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    }
                    for (Property prop : property.getValue().asPropertyList()) {
                        if ("long-running-threads".equals(prop.getName()) && prop.getValue().isDefined() && prop.getValue().asPropertyList().size() != 0) {
                            ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty().getValue(), Element.LONG_RUNNING_THREADS.getLocalName(), false);
                        }
                        if (!"short-running-threads".equals(prop.getName())) continue;
                        ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty().getValue(), Element.SHORT_RUNNING_THREADS.getLocalName(), false);
                    }
                    writer.writeEndElement();
                }
            }
        }

        private void writeBootstrapContexts(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("bootstrap-context") && parentNode.get("bootstrap-context").asList().size() != 0) {
                boolean started = false;
                for (ModelNode node : parentNode.get("bootstrap-context").asList()) {
                    if (!BootstrapContextAdd.BootstrapCtxParameters.NAME.getAttribute().isMarshallable(node) && !BootstrapContextAdd.BootstrapCtxParameters.WORKMANAGER.getAttribute().isMarshallable(node)) continue;
                    if (!started) {
                        writer.writeStartElement(Element.BOOTSTRAP_CONTEXTS.getLocalName());
                        started = true;
                    }
                    writer.writeStartElement(Element.BOOTSTRAP_CONTEXT.getLocalName());
                    BootstrapContextAdd.BootstrapCtxParameters.NAME.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    BootstrapContextAdd.BootstrapCtxParameters.WORKMANAGER.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (started) {
                    writer.writeEndElement();
                }
            }
        }

        private boolean hasAnyOf(ModelNode node, String ... names) {
            for (String current : names) {
                if (!this.has(node, current)) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeAttribute(attr.getLocalName(), value.asString());
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "jca");
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            EnumSet<Element> requiredElement = EnumSet.of(Element.DEFAULT_WORKMANAGER);
            boolean ccmAdded = false;
            block11: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case JCA_1_1: 
                    case JCA_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!visited.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case ARCHIVE_VALIDATION: {
                                list.add(this.parseArchiveValidation(reader, address));
                                continue block11;
                            }
                            case BEAN_VALIDATION: {
                                list.add(this.parseBeanValidation(reader, address));
                                continue block11;
                            }
                            case DEFAULT_WORKMANAGER: {
                                this.parseWorkManager(reader, address, list, subsystem, true);
                                ModelNode bootstrapContextOperation = new ModelNode();
                                bootstrapContextOperation.get("operation").set("add");
                                ModelNode bootStrapCOntextAddress = address.clone();
                                bootStrapCOntextAddress.add("bootstrap-context", "default");
                                bootStrapCOntextAddress.protect();
                                bootstrapContextOperation.get("address").set(bootStrapCOntextAddress);
                                bootstrapContextOperation.get("workmanager").set("default");
                                bootstrapContextOperation.get("name").set("default");
                                list.add(bootstrapContextOperation);
                                requiredElement.remove((Object)Element.DEFAULT_WORKMANAGER);
                                continue block11;
                            }
                            case CACHED_CONNECTION_MANAGER: {
                                list.add(this.parseCcm(reader, address));
                                ccmAdded = true;
                                continue block11;
                            }
                            case WORKMANAGER: {
                                this.parseWorkManager(reader, address, list, subsystem, false);
                                continue block11;
                            }
                            case BOOTSTRAP_CONTEXTS: {
                                ModelNode operation = this.parseBootstrapContexts(reader, address);
                                if (operation == null) continue block11;
                                list.add(operation);
                                continue block11;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!requiredElement.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredElement);
            }
            if (!ccmAdded) {
                ModelNode ccmOperation = new ModelNode();
                ccmOperation.get("operation").set("add");
                ModelNode ccmAddress = address.clone();
                ccmAddress.add("cached-connection-manager", "cached-connection-manager");
                ccmAddress.protect();
                ccmOperation.get("address").set(ccmAddress);
                list.add(ccmOperation);
            }
        }

        private ModelNode parseArchiveValidation(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode archiveValidationOperation = new ModelNode();
            archiveValidationOperation.get("operation").set("add");
            ModelNode archiveValidationAddress = parentOperation.clone();
            archiveValidationAddress.add("archive-validation", "archive-validation");
            archiveValidationAddress.protect();
            archiveValidationOperation.get("address").set(archiveValidationAddress);
            int cnt = reader.getAttributeCount();
            block5: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().getXmlName());
                        ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case FAIL_ON_ERROR: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().getXmlName());
                        ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case FAIL_ON_WARN: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().getXmlName());
                        ArchiveValidationAdd.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return archiveValidationOperation;
        }

        private void parseWorkManager(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, ModelNode node, boolean defaultWm) throws XMLStreamException {
            ModelNode workManagerOperation = new ModelNode();
            workManagerOperation.get("operation").set("add");
            int cnt = reader.getAttributeCount();
            String name = null;
            block7: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = this.rawAttributeText((XMLStreamReader)reader, WorkManagerAdd.WmParameters.NAME.getAttribute().getXmlName());
                        WorkManagerAdd.WmParameters.NAME.getAttribute().parseAndSetParameter(name, workManagerOperation, (XMLStreamReader)reader);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                if (defaultWm) {
                    name = "default";
                    workManagerOperation.get("name").set(name);
                } else {
                    throw new XMLStreamException("name attribute is mandatory for workmanager element");
                }
            }
            ModelNode workManagerAddress = parentAddress.clone();
            workManagerAddress.add("workmanager", name);
            workManagerAddress.protect();
            workManagerOperation.get("address").set(workManagerAddress);
            list.add(workManagerOperation);
            block8: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case LONG_RUNNING_THREADS: {
                        ThreadsParser.getInstance().parseBoundedQueueThreadPool(reader, workManagerAddress, list, "long-running-threads", name + "-" + "long-running-threads");
                        continue block8;
                    }
                    case SHORT_RUNNING_THREADS: {
                        ThreadsParser.getInstance().parseBoundedQueueThreadPool(reader, workManagerAddress, list, "short-running-threads", name + "-" + "short-running-threads");
                        continue block8;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            for (ModelNode op : list) {
                if (!op.hasDefined("blocking")) continue;
                op.get("blocking").set(Boolean.TRUE.booleanValue());
            }
        }

        private ModelNode parseBeanValidation(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode beanValidationOperation = new ModelNode();
            beanValidationOperation.get("operation").set("add");
            ModelNode beanValidationAddress = parentOperation.clone();
            beanValidationAddress.add("bean-validation", "bean-validation");
            beanValidationAddress.protect();
            beanValidationOperation.get("address").set(beanValidationAddress);
            int cnt = reader.getAttributeCount();
            block3: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, BeanValidationAdd.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().getXmlName());
                        BeanValidationAdd.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().parseAndSetParameter(value, beanValidationOperation, (XMLStreamReader)reader);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return beanValidationOperation;
        }

        private ModelNode parseCcm(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode ccmOperation = new ModelNode();
            ccmOperation.get("operation").set("add");
            ModelNode ccmAddress = parentOperation.clone();
            ccmAddress.add("cached-connection-manager", "cached-connection-manager");
            ccmAddress.protect();
            ccmOperation.get("address").set(ccmAddress);
            int cnt = reader.getAttributeCount();
            block4: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DEBUG: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, CachedConnectionManagerAdd.CcmParameters.DEBUG.getAttribute().getXmlName());
                        CachedConnectionManagerAdd.CcmParameters.DEBUG.getAttribute().parseAndSetParameter(value, ccmOperation, (XMLStreamReader)reader);
                        continue block4;
                    }
                    case ERROR: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, CachedConnectionManagerAdd.CcmParameters.ERROR.getAttribute().getXmlName());
                        CachedConnectionManagerAdd.CcmParameters.ERROR.getAttribute().parseAndSetParameter(value, ccmOperation, (XMLStreamReader)reader);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return ccmOperation;
        }

        private ModelNode parseBootstrapContexts(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
            ModelNode bootstrapContextOperation = null;
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case BOOTSTRAP_CONTEXT: {
                        bootstrapContextOperation = new ModelNode();
                        bootstrapContextOperation.get("operation").set("add");
                        int cnt = reader.getAttributeCount();
                        String name = null;
                        String wmName = null;
                        block8: for (int i = 0; i < cnt; ++i) {
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = this.rawAttributeText((XMLStreamReader)reader, BootstrapContextAdd.BootstrapCtxParameters.NAME.getAttribute().getXmlName());
                                    BootstrapContextAdd.BootstrapCtxParameters.NAME.getAttribute().parseAndSetParameter(name, bootstrapContextOperation, (XMLStreamReader)reader);
                                    continue block8;
                                }
                                case WORKMANAGER: {
                                    wmName = this.rawAttributeText((XMLStreamReader)reader, BootstrapContextAdd.BootstrapCtxParameters.WORKMANAGER.getAttribute().getXmlName());
                                    BootstrapContextAdd.BootstrapCtxParameters.WORKMANAGER.getAttribute().parseAndSetParameter(wmName, bootstrapContextOperation, (XMLStreamReader)reader);
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            if ("default".equals(wmName)) {
                                name = "default";
                            } else {
                                throw new XMLStreamException("name attribute is mandatory for workmanager element");
                            }
                        }
                        ModelNode bootStrapCOntextAddress = parentAddress.clone();
                        bootStrapCOntextAddress.add("bootstrap-context", name);
                        bootStrapCOntextAddress.protect();
                        bootstrapContextOperation.get("address").set(bootStrapCOntextAddress);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return bootstrapContextOperation;
        }

        public String rawElementText(XMLStreamReader reader) throws XMLStreamException {
            String elementtext = reader.getElementText();
            elementtext = elementtext == null || elementtext.trim().length() == 0 ? null : elementtext.trim();
            return elementtext;
        }

        public String rawAttributeText(XMLStreamReader reader, String attributeName) {
            String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
            return attributeString;
        }
    }
}

