/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.deployment;

import java.io.File;
import java.net.URL;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.services.ResourceAdapterService;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class ResourceAdapterXmlDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector");
    private final Module module;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private final ResourceAdapter raxml;
    private final String deployment;

    public ResourceAdapterXmlDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, ResourceAdapter raxml, Module module, String deployment) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        this.raxml = raxml;
        this.module = module;
        this.deployment = deployment;
    }

    public void start(StartContext context) throws StartException {
        try {
            String archive = this.raxml.getArchive();
            Connector cmd = ((MetadataRepository)this.mdr.getValue()).getResourceAdapter(this.deployment);
            IronJacamar ijmd = ((MetadataRepository)this.mdr.getValue()).getIronJacamar(this.deployment);
            File root = ((MetadataRepository)this.mdr.getValue()).getRoot(this.deployment);
            cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)this.raxml, cmd);
            String deploymentName = archive.substring(0, archive.indexOf(".rar"));
            ServiceContainer container = context.getController().getServiceContainer();
            AS7RaXmlDeployer raDeployer = new AS7RaXmlDeployer(context.getChildTarget(), this.connectorXmlDescriptor.getUrl(), deploymentName, root, (ClassLoader)this.module.getClassLoader(), cmd, this.raxml, ijmd);
            raDeployer.setConfiguration((Configuration)this.config.getValue());
            CommonDeployment raxmlDeployment = null;
            try {
                raxmlDeployment = raDeployer.doDeploy();
            }
            catch (Throwable t) {
                throw new StartException("Failed to start RA deployment [" + deploymentName + "]", t);
            }
            this.value = new ResourceAdapterDeployment(raxmlDeployment);
            ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
            if (raxmlDeployment.getResourceAdapter() != null) {
                ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
                ServiceName serviceName = ConnectorServices.getNextValidResourceAdapterServiceName(this.value.getDeployment().getDeploymentName());
                log.infof("Starting sevice %s", (Object)serviceName);
                context.getChildTarget().addService(serviceName, (Service)new ResourceAdapterService(this.value.getDeployment().getResourceAdapter())).setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    @Override
    public void stop(StopContext context) {
        log.debugf("Stopping sevice %s", (Object)ConnectorServices.RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
        ((ManagementRepository)this.managementRepository.getValue()).getConnectors().remove(this.value.getDeployment().getConnector());
        super.stop(context);
    }

    private class AS7RaXmlDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractAS7RaDeployer {
        private final ResourceAdapter ra;
        private final IronJacamar ijmd;

        public AS7RaXmlDeployer(ServiceTarget serviceTarget, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, ResourceAdapter ra, IronJacamar ijmd) {
            super(serviceTarget, url, deploymentName, root, cl, cmd);
            this.ra = ra;
            this.ijmd = ijmd;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterXmlDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.ijmd, this.ra);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            return true;
        }

        protected DeployersLogger getLogger() {
            return (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)AS7RaXmlDeployer.class.getName());
        }
    }
}

