/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.registry.DriverService;
import org.jboss.as.connector.registry.InstalledDriver;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JdbcDriverAdd
extends AbstractAddStepHandler {
    static final JdbcDriverAdd INSTANCE = new JdbcDriverAdd();
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    protected void populateModel(ModelNode operation, ModelNode model) {
        String driverName = operation.require("driver-name").asString();
        String moduleName = operation.require("driver-module-name").asString();
        Integer majorVersion = operation.hasDefined("driver-major-version") ? Integer.valueOf(operation.get("driver-major-version").asInt()) : null;
        Integer minorVersion = operation.hasDefined("driver-minor-version") ? Integer.valueOf(operation.get("driver-minor-version").asInt()) : null;
        String driverClassName = operation.hasDefined("driver-class-name") ? operation.get("driver-class-name").asString() : null;
        String xaDataSourceClassName = operation.hasDefined("driver-xa-datasource-class-name") ? operation.get("driver-xa-datasource-class-name").asString() : null;
        model.get("driver-name").set(driverName);
        model.get("driver-module-name").set(moduleName);
        if (majorVersion != null) {
            model.get("driver-major-version").set(majorVersion.intValue());
        }
        if (minorVersion != null) {
            model.get("driver-minor-version").set(minorVersion.intValue());
        }
        if (driverClassName != null) {
            model.get("driver-class-name").set(driverClassName);
        }
        if (xaDataSourceClassName != null) {
            model.get("driver-xa-datasource-class-name").set(xaDataSourceClassName);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        block6: {
            Module module;
            ModuleIdentifier moduleId;
            ServiceTarget target;
            String xaDataSourceClassName;
            String driverClassName;
            Integer minorVersion;
            Integer majorVersion;
            String driverName;
            block5: {
                driverName = operation.require("driver-name").asString();
                String moduleName = operation.require("driver-module-name").asString();
                majorVersion = operation.hasDefined("driver-major-version") ? Integer.valueOf(operation.get("driver-major-version").asInt()) : null;
                minorVersion = operation.hasDefined("driver-minor-version") ? Integer.valueOf(operation.get("driver-minor-version").asInt()) : null;
                driverClassName = operation.hasDefined("driver-class-name") ? operation.get("driver-class-name").asString() : null;
                xaDataSourceClassName = operation.hasDefined("driver-xa-datasource-class-name") ? operation.get("driver-xa-datasource-class-name").asString() : null;
                target = context.getServiceTarget();
                try {
                    moduleId = ModuleIdentifier.create((String)moduleName);
                    module = Module.getCallerModuleLoader().loadModule(moduleId);
                }
                catch (ModuleLoadException e) {
                    context.getFailureDescription().set("Failed to load module for driver [" + moduleName + "]");
                    return;
                }
                if (driverClassName != null) break block5;
                ServiceLoader serviceLoader = module.loadService(Driver.class);
                if (serviceLoader == null) break block6;
                for (Driver driver : serviceLoader) {
                    this.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, xaDataSourceClassName);
                }
                break block6;
            }
            try {
                Class<Driver> driverClass = module.getClassLoader().loadClass(driverClassName).asSubclass(Driver.class);
                Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                Driver driver = constructor.newInstance(new Object[0]);
                this.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, xaDataSourceClassName);
            }
            catch (Exception e) {
                log.warnf("Unable to instantiate driver class \"%s\": %s", (Object)driverClassName, (Object)e);
            }
        }
    }

    private void startDriverServices(ServiceTarget target, ModuleIdentifier moduleId, Driver driver, String driverName, Integer majorVersion, Integer minorVersion, String xaDataSourceClassName) throws IllegalStateException {
        int majorVer = driver.getMajorVersion();
        int minorVer = driver.getMinorVersion();
        if (majorVersion != null && majorVersion != majorVer || minorVersion != null && minorVersion != minorVer) {
            throw new IllegalStateException("Specified driver version doesn't match with actual driver version");
        }
        boolean compliant = driver.jdbcCompliant();
        if (compliant) {
            log.infof("Deploying JDBC-compliant driver %s (version %d.%d)", driver.getClass(), (Object)majorVer, (Object)minorVer);
        } else {
            log.infof("Deploying non-JDBC-compliant driver %s (version %d.%d)", driver.getClass(), (Object)majorVer, (Object)minorVer);
        }
        InstalledDriver driverMetadata = new InstalledDriver(driverName, moduleId, driver.getClass().getName(), xaDataSourceClassName, majorVer, minorVer, compliant);
        DriverService driverService = new DriverService(driverMetadata, driver);
        target.addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

