/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.ServiceLoader;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class JdbcDriverRemove
implements ModelRemoveOperationHandler {
    static final JdbcDriverRemove INSTANCE = new JdbcDriverRemove();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode model = context.getSubModel();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        final String moduleName = model.get("driver").asString();
        compensating.get("driver").set(model.get("driver"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    Module module;
                    ServiceRegistry registry = context.getServiceRegistry();
                    try {
                        module = Module.getCallerModuleLoader().loadModule(ModuleIdentifier.create((String)moduleName));
                    }
                    catch (ModuleLoadException e) {
                        throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to load module for driver [" + moduleName + "]"));
                    }
                    ServiceLoader serviceLoader = module.loadService(Driver.class);
                    if (serviceLoader != null) {
                        for (Driver driver : serviceLoader) {
                            int majorVersion = driver.getMajorVersion();
                            int minorVersion = driver.getMinorVersion();
                            ServiceName serviceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driver.getClass().getName(), Integer.toString(majorVersion), Integer.toString(minorVersion)});
                            ServiceController controller = registry.getService(serviceName);
                            if (controller == null) continue;
                            controller.addListener((ServiceListener)new ResultHandler.ServiceRemoveListener(resultHandler));
                        }
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

