/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.connector.subsystems.datasources.AttributeDefinition;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class DataSourcesSubsystemProviders {
    static final AttributeDefinition[] DATASOURCE_ATTRIBUTE = new AttributeDefinition[]{AttributeDefinition.CONNECTION_URL, AttributeDefinition.DRIVER_CLASS, AttributeDefinition.JNDINAME, AttributeDefinition.MODULE, AttributeDefinition.NEW_CONNECTION_SQL, AttributeDefinition.POOLNAME, AttributeDefinition.URL_DELIMITER, AttributeDefinition.URL_SELECTOR_STRATEGY_CLASS_NAME, AttributeDefinition.USE_JAVA_CONTEXT, AttributeDefinition.ENABLED, AttributeDefinition.MAX_POOL_SIZE, AttributeDefinition.MIN_POOL_SIZE, AttributeDefinition.POOL_PREFILL, AttributeDefinition.POOL_USE_STRICT_MIN, AttributeDefinition.USERNAME, AttributeDefinition.PASSWORD, AttributeDefinition.PREPAREDSTATEMENTSCACHESIZE, AttributeDefinition.SHAREPREPAREDSTATEMENTS, AttributeDefinition.TRACKSTATEMENTS, AttributeDefinition.ALLOCATION_RETRY, AttributeDefinition.ALLOCATION_RETRY_WAIT_MILLIS, AttributeDefinition.BLOCKING_TIMEOUT_WAIT_MILLIS, AttributeDefinition.IDLETIMEOUTMINUTES, AttributeDefinition.QUERYTIMEOUT, AttributeDefinition.USETRYLOCK, AttributeDefinition.SETTXQUERYTIMEOUT, AttributeDefinition.TRANSACTION_ISOLOATION, AttributeDefinition.CHECKVALIDCONNECTIONSQL, AttributeDefinition.EXCEPTIONSORTERCLASSNAME, AttributeDefinition.STALECONNECTIONCHECKERCLASSNAME, AttributeDefinition.VALIDCONNECTIONCHECKERCLASSNAME, AttributeDefinition.BACKGROUNDVALIDATIONMINUTES, AttributeDefinition.BACKGROUNDVALIDATION, AttributeDefinition.USE_FAST_FAIL, AttributeDefinition.VALIDATEONMATCH, AttributeDefinition.SPY};
    static final AttributeDefinition[] XA_DATASOURCE_ATTRIBUTE = new AttributeDefinition[]{AttributeDefinition.XADATASOURCECLASS, AttributeDefinition.JNDINAME, AttributeDefinition.MODULE, AttributeDefinition.NEW_CONNECTION_SQL, AttributeDefinition.POOLNAME, AttributeDefinition.URL_DELIMITER, AttributeDefinition.URL_SELECTOR_STRATEGY_CLASS_NAME, AttributeDefinition.USE_JAVA_CONTEXT, AttributeDefinition.ENABLED, AttributeDefinition.MAX_POOL_SIZE, AttributeDefinition.MIN_POOL_SIZE, AttributeDefinition.POOL_PREFILL, AttributeDefinition.POOL_USE_STRICT_MIN, AttributeDefinition.INTERLIVING, AttributeDefinition.NOTXSEPARATEPOOL, AttributeDefinition.PAD_XID, AttributeDefinition.SAME_RM_OVERRIDE, AttributeDefinition.WRAP_XA_DATASOURCE, AttributeDefinition.USERNAME, AttributeDefinition.PASSWORD, AttributeDefinition.PREPAREDSTATEMENTSCACHESIZE, AttributeDefinition.SHAREPREPAREDSTATEMENTS, AttributeDefinition.TRACKSTATEMENTS, AttributeDefinition.ALLOCATION_RETRY, AttributeDefinition.ALLOCATION_RETRY_WAIT_MILLIS, AttributeDefinition.BLOCKING_TIMEOUT_WAIT_MILLIS, AttributeDefinition.IDLETIMEOUTMINUTES, AttributeDefinition.QUERYTIMEOUT, AttributeDefinition.USETRYLOCK, AttributeDefinition.SETTXQUERYTIMEOUT, AttributeDefinition.TRANSACTION_ISOLOATION, AttributeDefinition.CHECKVALIDCONNECTIONSQL, AttributeDefinition.EXCEPTIONSORTERCLASSNAME, AttributeDefinition.STALECONNECTIONCHECKERCLASSNAME, AttributeDefinition.VALIDCONNECTIONCHECKERCLASSNAME, AttributeDefinition.BACKGROUNDVALIDATIONMINUTES, AttributeDefinition.BACKGROUNDVALIDATION, AttributeDefinition.USE_FAST_FAIL, AttributeDefinition.VALIDATEONMATCH, AttributeDefinition.XA_RESOURCE_TIMEOUT, AttributeDefinition.SPY};
    static final String RESOURCE_NAME = DataSourcesSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("datasources"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.DATASOURCES_1_0.getUriString());
            subsystem.get(new String[]{"children", "jdbc-driver", "description"}).set(bundle.getString("jdbc-driver"));
            subsystem.get(new String[]{"children", "jdbc-driver", "required"}).set(false);
            subsystem.get(new String[]{"children", "data-source", "description"}).set(bundle.getString("data-source"));
            subsystem.get(new String[]{"children", "data-source", "required"}).set(false);
            subsystem.get(new String[]{"children", "xa-data-source", "description"}).set(bundle.getString("xa-data-source"));
            subsystem.get(new String[]{"children", "xa-data-source", "required"}).set(false);
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("data-source.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider JDBC_DRIVER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("jdbc-driver.description"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            node.get(new String[]{"attributes", "driver", "description"}).set(bundle.getString("jdbc-driver.module"));
            node.get(new String[]{"attributes", "driver", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "driver", "required"}).set(true);
            return node;
        }
    };
    static DescriptionProvider ADD_JDBC_DRIVER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("jdbc-driver.add"));
            operation.get(new String[]{"request-properties", "driver", "description"}).set(bundle.getString("jdbc-driver.module"));
            operation.get(new String[]{"request-properties", "driver", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "driver", "required"}).set(true);
            return operation;
        }
    };
    static DescriptionProvider REMOVE_JDBC_DRIVER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("jdbc-driver.remove"));
            return operation;
        }
    };
    static DescriptionProvider DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("data-source.description"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            for (AttributeDefinition propertyType : DATASOURCE_ATTRIBUTE) {
                node.get(new String[]{"attributes", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                node.get(new String[]{"attributes", propertyType.getName(), "type"}).set(propertyType.getModelType());
                node.get(new String[]{"attributes", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            return node;
        }
    };
    static DescriptionProvider ADD_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("data-source.add"));
            for (AttributeDefinition propertyType : DATASOURCE_ATTRIBUTE) {
                operation.get(new String[]{"request-properties", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                operation.get(new String[]{"request-properties", propertyType.getName(), "type"}).set(propertyType.getModelType());
                operation.get(new String[]{"request-properties", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            return operation;
        }
    };
    static DescriptionProvider REMOVE_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("data-source.remove"));
            return operation;
        }
    };
    static DescriptionProvider ENABLE_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("enable");
            operation.get("description").set(bundle.getString("data-source.enable"));
            return operation;
        }
    };
    static DescriptionProvider DISABLE_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("disable");
            operation.get("description").set(bundle.getString("data-source.disable"));
            return operation;
        }
    };
    static DescriptionProvider XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("xa-data-source.description"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            for (AttributeDefinition propertyType : XA_DATASOURCE_ATTRIBUTE) {
                node.get(new String[]{"attributes", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                node.get(new String[]{"attributes", propertyType.getName(), "type"}).set(propertyType.getModelType());
                node.get(new String[]{"attributes", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            return node;
        }
    };
    static DescriptionProvider ADD_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("xa-data-source.add"));
            for (AttributeDefinition propertyType : XA_DATASOURCE_ATTRIBUTE) {
                operation.get(new String[]{"request-properties", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                operation.get(new String[]{"request-properties", propertyType.getName(), "type"}).set(propertyType.getModelType());
                operation.get(new String[]{"request-properties", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            return operation;
        }
    };
    static DescriptionProvider REMOVE_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("xa-data-source.remove"));
            return operation;
        }
    };
    static DescriptionProvider ENABLE_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("enable");
            operation.get("description").set(bundle.getString("xa-data-source.enable"));
            return operation;
        }
    };
    static DescriptionProvider DISABLE_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("disable");
            operation.get("description").set(bundle.getString("xa-data-source.disable"));
            return operation;
        }
    };

    DataSourcesSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

