/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.ds.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;

class DataSourceModelNodeUtil {
    DataSourceModelNodeUtil() {
    }

    static void fillFrom(ModelNode dataSourceModel, DataSource dataSource) {
        Validation validation;
        TimeOut timeout;
        Statement statement;
        DsSecurity security;
        for (Map.Entry entry : dataSource.getConnectionProperties().entrySet()) {
            dataSourceModel.get(new String[]{"connection-properties", (String)entry.getKey()}).set((String)entry.getValue());
        }
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "connection-url", dataSource.getConnectionUrl());
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "driver-class", dataSource.getDriverClass());
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "jndi-name", dataSource.getJndiName());
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "driver", dataSource.getDriver());
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "new-connection-sql", dataSource.getNewConnectionSql());
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "pool-name", dataSource.getPoolName());
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "url-delimiter", dataSource.getUrlDelimiter());
        DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "url-selector-strategy-class-name", dataSource.getUrlSelectorStrategyClassName());
        DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "use-java-context", dataSource.isUseJavaContext());
        DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "enabled", dataSource.isEnabled());
        CommonPool pool = dataSource.getPool();
        if (pool != null) {
            DataSourceModelNodeUtil.setIntegerIfNotNull(dataSourceModel, "max-pool-size", pool.getMaxPoolSize());
            DataSourceModelNodeUtil.setIntegerIfNotNull(dataSourceModel, "min-pool-size", pool.getMinPoolSize());
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "pool-prefill", pool.isPrefill());
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "pool-use-strict-min", pool.isUseStrictMin());
        }
        if ((security = dataSource.getSecurity()) != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "user-name", security.getUserName());
            DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "password", security.getPassword());
            DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "security-domain", security.getSecurityDomain());
            DataSourceModelNodeUtil.setExtensionIfNotNull(dataSourceModel, "reauth-plugin-class-name", "reauth-plugin-properties", security.getReauthPlugin());
        }
        if ((statement = dataSource.getStatement()) != null) {
            DataSourceModelNodeUtil.setLongIfNotNull(dataSourceModel, "prepared-statements-cacheSize", statement.getPreparedStatementsCacheSize());
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "share-prepared-statements", statement.isSharePreparedStatements());
            if (statement.getTrackStatements() != null) {
                DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "track-statements", statement.getTrackStatements().name());
            }
        }
        if ((timeout = dataSource.getTimeOut()) != null) {
            DataSourceModelNodeUtil.setIntegerIfNotNull(dataSourceModel, "allocation-retry", timeout.getAllocationRetry());
            DataSourceModelNodeUtil.setLongIfNotNull(dataSourceModel, "allocation-retry-wait-millis", timeout.getAllocationRetryWaitMillis());
            DataSourceModelNodeUtil.setLongIfNotNull(dataSourceModel, "blocking-timeout-wait-millis", timeout.getBlockingTimeoutMillis());
            DataSourceModelNodeUtil.setLongIfNotNull(dataSourceModel, "idle-timeout-minutes", timeout.getIdleTimeoutMinutes());
            DataSourceModelNodeUtil.setLongIfNotNull(dataSourceModel, "query-timeout", timeout.getQueryTimeout());
            DataSourceModelNodeUtil.setLongIfNotNull(dataSourceModel, "use-try-lock", timeout.getUseTryLock());
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "set-tx-query-timeout", timeout.isSetTxQueryTimeout());
        }
        if (dataSource.getTransactionIsolation() != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "transaction-isolation", dataSource.getTransactionIsolation().name());
        }
        if (dataSource.isSpy()) {
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "spy", dataSource.isSpy());
        }
        if ((validation = dataSource.getValidation()) != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(dataSourceModel, "check-valid-connection-sql", validation.getCheckValidConnectionSql());
            DataSourceModelNodeUtil.setExtensionIfNotNull(dataSourceModel, "exception-sorter-class-name", "exceptionsorter-properties", validation.getExceptionSorter());
            DataSourceModelNodeUtil.setExtensionIfNotNull(dataSourceModel, "stale-connection-checker-class-name", "staleconnectionchecker-properties", validation.getStaleConnectionChecker());
            DataSourceModelNodeUtil.setExtensionIfNotNull(dataSourceModel, "valid-connection-checker-class-name", "validconnectionchecker-properties", validation.getValidConnectionChecker());
            DataSourceModelNodeUtil.setLongIfNotNull(dataSourceModel, "background-validation-minutes", validation.getBackgroundValidationMinutes());
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "background-validation", validation.isBackgroundValidation());
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "use-fast-fail", validation.isUseFastFail());
            DataSourceModelNodeUtil.setBooleanIfNotNull(dataSourceModel, "validate-on-match", validation.isValidateOnMatch());
        }
    }

    static void fillFrom(ModelNode xaDataSourceModel, XaDataSource xaDataSource) {
        TimeOut timeout;
        Statement statement;
        DsSecurity security;
        for (Map.Entry entry : xaDataSource.getXaDataSourceProperty().entrySet()) {
            xaDataSourceModel.get(new String[]{"xa-data-source-properties", (String)entry.getKey()}).set((String)entry.getValue());
        }
        DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "xa-data-source-class", xaDataSource.getXaDataSourceClass());
        DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "jndi-name", xaDataSource.getJndiName());
        DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "driver", xaDataSource.getDriver());
        DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "new-connection-sql", xaDataSource.getNewConnectionSql());
        DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "pool-name", xaDataSource.getPoolName());
        DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "url-delimiter", xaDataSource.getUrlDelimiter());
        DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "url-selector-strategy-class-name", xaDataSource.getUrlSelectorStrategyClassName());
        DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "use-java-context", xaDataSource.isUseJavaContext());
        DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "enabled", xaDataSource.isEnabled());
        CommonXaPool pool = xaDataSource.getXaPool();
        if (pool != null) {
            DataSourceModelNodeUtil.setIntegerIfNotNull(xaDataSourceModel, "max-pool-size", pool.getMaxPoolSize());
            DataSourceModelNodeUtil.setIntegerIfNotNull(xaDataSourceModel, "min-pool-size", pool.getMinPoolSize());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "pool-prefill", pool.isPrefill());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "pool-use-strict-min", pool.isUseStrictMin());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "interliving", pool.isInterleaving());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "no-tx-separate-pool", pool.isNoTxSeparatePool());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "pad-xid", pool.isPadXid());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "same-rm-override", pool.isSameRmOverride());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "wrap-xa-datasource", pool.isWrapXaDataSource());
        }
        if ((security = xaDataSource.getSecurity()) != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "user-name", security.getUserName());
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "password", security.getPassword());
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "security-domain", security.getSecurityDomain());
            DataSourceModelNodeUtil.setExtensionIfNotNull(xaDataSourceModel, "reauth-plugin-class-name", "reauth-plugin-properties", security.getReauthPlugin());
        }
        if ((statement = xaDataSource.getStatement()) != null) {
            DataSourceModelNodeUtil.setLongIfNotNull(xaDataSourceModel, "prepared-statements-cacheSize", statement.getPreparedStatementsCacheSize());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "share-prepared-statements", statement.isSharePreparedStatements());
            if (statement.getTrackStatements() != null) {
                DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "track-statements", statement.getTrackStatements().name());
            }
        }
        if ((timeout = xaDataSource.getTimeOut()) != null) {
            DataSourceModelNodeUtil.setIntegerIfNotNull(xaDataSourceModel, "allocation-retry", timeout.getAllocationRetry());
            DataSourceModelNodeUtil.setLongIfNotNull(xaDataSourceModel, "allocation-retry-wait-millis", timeout.getAllocationRetryWaitMillis());
            DataSourceModelNodeUtil.setLongIfNotNull(xaDataSourceModel, "blocking-timeout-wait-millis", timeout.getBlockingTimeoutMillis());
            DataSourceModelNodeUtil.setLongIfNotNull(xaDataSourceModel, "idle-timeout-minutes", timeout.getIdleTimeoutMinutes());
            DataSourceModelNodeUtil.setLongIfNotNull(xaDataSourceModel, "query-timeout", timeout.getQueryTimeout());
            DataSourceModelNodeUtil.setLongIfNotNull(xaDataSourceModel, "use-try-lock", timeout.getUseTryLock());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "set-tx-query-timeout", timeout.isSetTxQueryTimeout());
            DataSourceModelNodeUtil.setIntegerIfNotNull(xaDataSourceModel, "xa-resource-timeout", timeout.getXaResourceTimeout());
        }
        if (xaDataSource.getTransactionIsolation() != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "transaction-isolation", xaDataSource.getTransactionIsolation().name());
        }
        if (xaDataSource.isSpy()) {
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "spy", xaDataSource.isSpy());
        }
        Validation validation = xaDataSource.getValidation();
        if (xaDataSource.getValidation() != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "check-valid-connection-sql", validation.getCheckValidConnectionSql());
            DataSourceModelNodeUtil.setExtensionIfNotNull(xaDataSourceModel, "exception-sorter-class-name", "exceptionsorter-properties", validation.getExceptionSorter());
            DataSourceModelNodeUtil.setExtensionIfNotNull(xaDataSourceModel, "stale-connection-checker-class-name", "staleconnectionchecker-properties", validation.getStaleConnectionChecker());
            DataSourceModelNodeUtil.setExtensionIfNotNull(xaDataSourceModel, "valid-connection-checker-class-name", "validconnectionchecker-properties", validation.getValidConnectionChecker());
            DataSourceModelNodeUtil.setLongIfNotNull(xaDataSourceModel, "background-validation-minutes", validation.getBackgroundValidationMinutes());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "background-validation", validation.isBackgroundValidation());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "use-fast-fail", validation.isUseFastFail());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "validate-on-match", validation.isValidateOnMatch());
        }
        if (xaDataSource.getRecovery() != null) {
            Recovery recovery = xaDataSource.getRecovery();
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "recovery-username", recovery.getCredential() != null ? recovery.getCredential().getUserName() : null);
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "recovery-password", recovery.getCredential() != null ? recovery.getCredential().getPassword() : null);
            DataSourceModelNodeUtil.setStringIfNotNull(xaDataSourceModel, "recovery-security-domain", recovery.getCredential() != null ? recovery.getCredential().getSecurityDomain() : null);
            DataSourceModelNodeUtil.setExtensionIfNotNull(xaDataSourceModel, "recovery-plugin-properties", "recovery-plugin-properties", recovery.getRecoverPlugin());
            DataSourceModelNodeUtil.setBooleanIfNotNull(xaDataSourceModel, "no-recovery", recovery.getNoRecovery());
        }
    }

    static DataSource from(ModelNode dataSourceNode) throws ValidateException {
        Map<String, String> connectionProperties;
        if (dataSourceNode.hasDefined("connection-properties")) {
            connectionProperties = new HashMap(dataSourceNode.get("connection-properties").asList().size());
            for (Property property : dataSourceNode.get("connection-properties").asPropertyList()) {
                connectionProperties.put(property.getName(), property.getValue().asString());
            }
        } else {
            connectionProperties = Collections.emptyMap();
        }
        String connectionUrl = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "connection-url", null);
        String driverClass = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "driver-class", null);
        String jndiName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "jndi-name", null);
        String module = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "driver", null);
        String newConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "new-connection-sql", null);
        String poolName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "pool-name", null);
        String urlDelimiter = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "url-delimiter", null);
        String urlSelectorStrategyClassName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "url-selector-strategy-class-name", null);
        boolean useJavaContext = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "use-java-context", false);
        boolean enabled = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "enabled", false);
        Integer maxPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "max-pool-size", null);
        Integer minPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "min-pool-size", null);
        boolean prefill = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-prefill", false);
        boolean useStrictMin = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-use-strict-min", false);
        CommonPoolImpl pool = new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin));
        String username = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "user-name", null);
        String password = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "password", null);
        String securityDomain = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "security-domain", null);
        Extension reauthPlugin = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "reauth-plugin-class-name", "reauth-plugin-properties");
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        boolean sharePreparedStatements = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "use-java-context", false);
        Long preparedStatementsCacheSize = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "prepared-statements-cacheSize", null);
        Statement.TrackStatementsEnum trackStatements = dataSourceNode.hasDefined("track-statements") ? Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get("track-statements").asString()) : Statement.TrackStatementsEnum.NOWARN;
        StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "allocation-retry", null);
        Long allocationRetryWaitMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "allocation-retry-wait-millis", null);
        Long blockingTimeoutMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "blocking-timeout-wait-millis", null);
        Long idleTimeoutMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "idle-timeout-minutes", null);
        Long queryTimeout = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "query-timeout", null);
        Integer xaResourceTimeout = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "xa-resource-timeout", null);
        Long useTryLock = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "use-try-lock", null);
        boolean setTxQuertTimeout = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "set-tx-query-timeout", false);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQuertTimeout), queryTimeout, useTryLock);
        TransactionIsolation transactionIsolation = dataSourceNode.hasDefined("transaction-isolation") ? TransactionIsolation.valueOf((String)dataSourceNode.get("transaction-isolation").asString()) : null;
        String checkValidConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "check-valid-connection-sql", null);
        Extension exceptionSorter = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "exception-sorter-class-name", "exceptionsorter-properties");
        Extension staleConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "stale-connection-checker-class-name", "staleconnectionchecker-properties");
        Extension validConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "valid-connection-checker-class-name", "validconnectionchecker-properties");
        Long backgroundValidationMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "background-validation-minutes", null);
        boolean backgroundValidation = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "background-validation", false);
        boolean useFastFail = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "use-fast-fail", false);
        boolean validateOnMatch = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "validate-on-match", false);
        boolean spy = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "spy", false);
        ValidationImpl validation = new ValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMinutes, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, Boolean.valueOf(validateOnMatch), staleConnectionChecker, exceptionSorter);
        return new DataSourceImpl(connectionUrl, driverClass, module, transactionIsolation, connectionProperties, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, (CommonPool)pool);
    }

    static XaDataSource xaFrom(ModelNode dataSourceNode) throws ValidateException {
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>(dataSourceNode.get("xa-data-source-properties").asList().size());
        for (ModelNode property : dataSourceNode.get("xa-data-source-properties").asList()) {
            xaDataSourceProperty.put(property.asProperty().getName(), property.asString());
        }
        String xaDataSourceClass = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "xa-data-source-class", null);
        String jndiName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "jndi-name", null);
        String module = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "driver", null);
        String newConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "new-connection-sql", null);
        String poolName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "pool-name", null);
        String urlDelimiter = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "url-delimiter", null);
        String urlSelectorStrategyClassName = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "url-selector-strategy-class-name", null);
        boolean useJavaContext = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "use-java-context", false);
        boolean enabled = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "enabled", false);
        Integer maxPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "max-pool-size", null);
        Integer minPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "min-pool-size", null);
        boolean prefill = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-prefill", false);
        boolean useStrictMin = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "pool-use-strict-min", false);
        boolean interleaving = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "interliving", false);
        boolean noTxSeparatePool = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "no-tx-separate-pool", false);
        boolean padXid = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "pad-xid", false);
        boolean isSameRmOverride = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "same-rm-override", false);
        boolean wrapXaDataSource = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "wrap-xa-datasource", false);
        CommonXaPoolImpl xaPool = new CommonXaPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), Boolean.valueOf(isSameRmOverride), Boolean.valueOf(interleaving), Boolean.valueOf(padXid), Boolean.valueOf(wrapXaDataSource), Boolean.valueOf(noTxSeparatePool));
        String username = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "user-name", null);
        String password = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "password", null);
        String securityDomain = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "security-domain", null);
        Extension reauthPlugin = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "reauth-plugin-class-name", "reauth-plugin-properties");
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        boolean sharePreparedStatements = dataSourceNode.hasDefined("share-prepared-statements") ? dataSourceNode.get("share-prepared-statements").asBoolean() : false;
        Long preparedStatementsCacheSize = dataSourceNode.get("prepared-statements-cacheSize").asLong();
        Statement.TrackStatementsEnum trackStatements = Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get("track-statements").asString());
        StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "allocation-retry", null);
        Long allocationRetryWaitMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "allocation-retry-wait-millis", null);
        Long blockingTimeoutMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "blocking-timeout-wait-millis", null);
        Long idleTimeoutMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "idle-timeout-minutes", null);
        Long queryTimeout = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "query-timeout", null);
        Integer xaResourceTimeout = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(dataSourceNode, "xa-resource-timeout", null);
        Long useTryLock = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "use-try-lock", null);
        boolean setTxQuertTimeout = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "set-tx-query-timeout", false);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQuertTimeout), queryTimeout, useTryLock);
        TransactionIsolation transactionIsolation = dataSourceNode.hasDefined("transaction-isolation") ? TransactionIsolation.valueOf((String)dataSourceNode.get("transaction-isolation").asString()) : null;
        String checkValidConnectionSql = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "check-valid-connection-sql", null);
        Extension exceptionSorter = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "exception-sorter-class-name", "exceptionsorter-properties");
        Extension staleConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "stale-connection-checker-class-name", "staleconnectionchecker-properties");
        Extension validConnectionChecker = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "valid-connection-checker-class-name", "validconnectionchecker-properties");
        Long backgroundValidationMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(dataSourceNode, "background-validation-minutes", null);
        boolean backgroundValidation = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "background-validation", false);
        boolean useFastFail = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "use-fast-fail", false);
        boolean validateOnMatch = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "validate-on-match", false);
        boolean spy = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "spy", false);
        ValidationImpl validation = new ValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMinutes, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, Boolean.valueOf(validateOnMatch), staleConnectionChecker, exceptionSorter);
        String recoveryUsername = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "recovery-username", null);
        String recoveryPassword = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "recovery-password", null);
        String recoverySecurityDomain = DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, "recovery-security-domain", null);
        CredentialImpl credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
        Extension recoverPlugin = DataSourceModelNodeUtil.extractExtension(dataSourceNode, "recovery-plugin-properties", "recovery-plugin-properties");
        boolean noRecovery = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(dataSourceNode, "no-recovery", false);
        Recovery recovery = new Recovery((Credential)credential, recoverPlugin, Boolean.valueOf(noRecovery));
        return new XADataSourceImpl(transactionIsolation, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, xaDataSourceProperty, xaDataSourceClass, module, newConnectionSql, (CommonXaPool)xaPool, recovery);
    }

    private static void setBooleanIfNotNull(ModelNode node, String identifier, Boolean value) {
        if (value != null) {
            node.get(identifier).set(value.booleanValue());
        }
    }

    private static void setIntegerIfNotNull(ModelNode node, String identifier, Integer value) {
        if (value != null) {
            node.get(identifier).set(value.intValue());
        }
    }

    private static void setLongIfNotNull(ModelNode node, String identifier, Long value) {
        if (value != null) {
            node.get(identifier).set(value.longValue());
        }
    }

    private static void setStringIfNotNull(ModelNode node, String identifier, String value) {
        if (value != null) {
            node.get(identifier).set(value);
        }
    }

    private static void setExtensionIfNotNull(ModelNode dsModel, String extensionclassname, String extensionProperties, Extension extension) {
        if (extension != null) {
            DataSourceModelNodeUtil.setStringIfNotNull(dsModel, extensionclassname, extension.getClassName());
            if (extension.getConfigPropertiesMap() != null) {
                for (Map.Entry entry : extension.getConfigPropertiesMap().entrySet()) {
                    dsModel.get(new String[]{extensionProperties, (String)entry.getKey()}).set((String)entry.getValue());
                }
            }
        }
    }

    private static Long getLongIfSetOrGetDefault(ModelNode dataSourceNode, String key, Long defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asLong();
        }
        return defaultValue;
    }

    private static Integer getIntIfSetOrGetDefault(ModelNode dataSourceNode, String key, Integer defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asInt();
        }
        return defaultValue;
    }

    private static boolean getBooleanIfSetOrGetDefault(ModelNode dataSourceNode, String key, boolean defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asBoolean();
        }
        return defaultValue;
    }

    private static String getStringIfSetOrGetDefault(ModelNode dataSourceNode, String key, String defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asString();
        }
        return defaultValue;
    }

    private static Extension extractExtension(ModelNode dataSourceNode, String className, String propertyName) throws ValidateException {
        if (dataSourceNode.hasDefined(className)) {
            String exceptionSorterClassName = dataSourceNode.get(className).asString();
            DataSourceModelNodeUtil.getStringIfSetOrGetDefault(dataSourceNode, className, null);
            HashMap<String, String> exceptionSorterProperty = null;
            if (dataSourceNode.hasDefined(propertyName)) {
                exceptionSorterProperty = new HashMap<String, String>(dataSourceNode.get(propertyName).asList().size());
                for (ModelNode property : dataSourceNode.get(propertyName).asList()) {
                    exceptionSorterProperty.put(property.asProperty().getName(), property.asString());
                }
            }
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }
}

