/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.deployers.processors.ResourceAdaptersAttachingProcessor;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonAdminObjectImpl;
import org.jboss.jca.common.metadata.common.CommonConnDefImpl;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterImpl;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdaptersImpl;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class ResourceAdaptersSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    static final ResourceAdaptersSubsystemAdd INSTANCE = new ResourceAdaptersSubsystemAdd();

    ResourceAdaptersSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        ModelNode subModel = context.getSubModel();
        subModel.setEmptyObject();
        boolean workaround = true;
        if (workaround) {
            if (operation.has("resource-adapters")) {
                ModelNode datasources = operation.get("resource-adapters");
                subModel.get("resource-adapters").set(datasources);
            }
        } else if (operation.hasDefined("resource-adapters")) {
            for (ModelNode raNode : operation.get("resource-adapters").asList()) {
                for (ModelNode property : raNode.get("config-properties").asList()) {
                    subModel.get(new String[]{"config-properties", property.asProperty().getName()}).set(property.asString());
                }
                for (String attribute : ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_ATTRIBUTE) {
                    if (!raNode.get(attribute).isDefined()) continue;
                    subModel.get(attribute).set(raNode.get(attribute));
                }
            }
        }
        if (context instanceof BootOperationContext) {
            final BootOperationContext updateContext = (BootOperationContext)context;
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    ResourceAdapters resourceAdapters = ResourceAdaptersSubsystemAdd.this.buildResourceAdaptersObject(operation);
                    serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService(resourceAdapters)).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    updateContext.addDeploymentProcessor(Phase.PARSE, 5632, (DeploymentUnitProcessor)new ResourceAdaptersAttachingProcessor(resourceAdapters));
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("remove");
        compensatingOperation.get("address").set(operation.require("address"));
        return new BasicOperationResult(compensatingOperation);
    }

    private ResourceAdapters buildResourceAdaptersObject(ModelNode operation) throws OperationFailedException {
        ArrayList<ResourceAdapterImpl> resourceAdapters = new ArrayList<ResourceAdapterImpl>();
        if (operation.hasDefined("resource-adapters")) {
            for (ModelNode raNode : operation.get("resource-adapters").asList()) {
                ResourceAdapterImpl ra;
                HashMap<String, String> configProperties = new HashMap<String, String>(raNode.get("config-properties").asList().size());
                for (ModelNode property : raNode.get("config-properties").asList()) {
                    configProperties.put(property.asProperty().getName(), property.asString());
                }
                String archive = this.getStringIfSetOrGetDefault(operation, "archive", null);
                TransactionSupportEnum transactionSupport = operation.hasDefined("transaction-support") ? TransactionSupportEnum.valueOf((String)operation.get("transaction-support").asString()) : null;
                String bootstrapContext = this.getStringIfSetOrGetDefault(operation, "bootstrapcontext", null);
                ArrayList<String> beanValidationGroups = new ArrayList<String>(operation.get("beanvalidationgroups").asList().size());
                for (ModelNode beanValidtion : operation.get("beanvalidationgroups").asList()) {
                    beanValidationGroups.add(beanValidtion.asString());
                }
                try {
                    ra = new ResourceAdapterImpl(archive, transactionSupport, this.buildConnectionDefinitionObject(operation), this.buildAdminObjects(operation), configProperties, beanValidationGroups, bootstrapContext);
                }
                catch (ValidateException e) {
                    throw new OperationFailedException((Throwable)e, operation);
                }
                resourceAdapters.add(ra);
            }
        }
        return new ResourceAdaptersImpl(resourceAdapters);
    }

    private List<CommonConnDef> buildConnectionDefinitionObject(ModelNode parentNode) throws ValidateException {
        ArrayList<CommonConnDef> connDefs = new ArrayList<CommonConnDef>();
        for (ModelNode conDefNode : parentNode.get("connection-definitions").asList()) {
            HashMap<String, String> configProperties = new HashMap<String, String>(conDefNode.get("config-properties").asList().size());
            for (ModelNode property : conDefNode.get("config-properties").asList()) {
                configProperties.put(property.asProperty().getName(), property.asString());
            }
            String className = this.getStringIfSetOrGetDefault(conDefNode, "class-name", null);
            String jndiName = this.getStringIfSetOrGetDefault(conDefNode, "jndi-name", null);
            String poolName = this.getStringIfSetOrGetDefault(conDefNode, "pool-name", null);
            boolean enabled = this.getBooleanIfSetOrGetDefault(conDefNode, "enabled", false);
            boolean useJavaContext = this.getBooleanIfSetOrGetDefault(conDefNode, "use-java-context", false);
            Integer maxPoolSize = this.getIntIfSetOrGetDefault(conDefNode, "max-pool-size", null);
            Integer minPoolSize = this.getIntIfSetOrGetDefault(conDefNode, "min-pool-size", null);
            boolean prefill = this.getBooleanIfSetOrGetDefault(conDefNode, "pool-prefill", false);
            boolean useStrictMin = this.getBooleanIfSetOrGetDefault(conDefNode, "pool-use-strict-min", false);
            Integer allocationRetry = this.getIntIfSetOrGetDefault(conDefNode, "allocation-retry", null);
            Long allocationRetryWaitMillis = this.getLongIfSetOrGetDefault(conDefNode, "allocation-retry-wait-millis", null);
            Long blockingTimeoutMillis = this.getLongIfSetOrGetDefault(conDefNode, "blocking-timeout-wait-millis", null);
            Long idleTimeoutMinutes = this.getLongIfSetOrGetDefault(conDefNode, "idle-timeout-minutes", null);
            Integer xaResourceTimeout = this.getIntIfSetOrGetDefault(conDefNode, "xa-resource-timeout", null);
            CommonTimeOutImpl timeOut = new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
            CommonPoolImpl pool = new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin));
            String securityDomain = this.getStringIfSetOrGetDefault(conDefNode, "security-domain", null);
            String securityDomainAndApplication = this.getStringIfSetOrGetDefault(conDefNode, "security-domain-and-application", null);
            boolean application = this.getBooleanIfSetOrGetDefault(conDefNode, "security-application", false);
            CommonSecurityImpl security = new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application);
            Long backgroundValidationMinutes = this.getLongIfSetOrGetDefault(conDefNode, "background-validation-minutes", null);
            boolean backgroundValidation = this.getBooleanIfSetOrGetDefault(conDefNode, "background-validation", false);
            boolean useFastFail = this.getBooleanIfSetOrGetDefault(conDefNode, "use-fast-fail", false);
            CommonValidationImpl validation = new CommonValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMinutes, Boolean.valueOf(useFastFail));
            CommonConnDefImpl connectionDefinition = new CommonConnDefImpl(configProperties, className, jndiName, poolName, Boolean.valueOf(enabled), Boolean.valueOf(useJavaContext), (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, (CommonSecurity)security);
            connDefs.add((CommonConnDef)connectionDefinition);
        }
        return connDefs;
    }

    private List<CommonAdminObject> buildAdminObjects(ModelNode parentNode) {
        ArrayList<CommonAdminObject> adminObjets = new ArrayList<CommonAdminObject>();
        for (ModelNode adminObject : parentNode.get("admin-objects").asList()) {
            HashMap<String, String> configProperties = new HashMap<String, String>(adminObject.get("config-properties").asList().size());
            for (ModelNode property : adminObject.get("config-properties").asList()) {
                configProperties.put(property.asProperty().getName(), property.asString());
            }
            String className = this.getStringIfSetOrGetDefault(adminObject, "class-name", null);
            String jndiName = this.getStringIfSetOrGetDefault(adminObject, "jndi-name", null);
            String poolName = this.getStringIfSetOrGetDefault(adminObject, "pool-name", null);
            boolean enabled = this.getBooleanIfSetOrGetDefault(adminObject, "enabled", false);
            boolean useJavaContext = this.getBooleanIfSetOrGetDefault(adminObject, "use-java-context", false);
            CommonAdminObjectImpl adminObjet = new CommonAdminObjectImpl(configProperties, className, jndiName, poolName, Boolean.valueOf(enabled), Boolean.valueOf(useJavaContext));
            adminObjets.add((CommonAdminObject)adminObjet);
        }
        return adminObjets;
    }

    private Long getLongIfSetOrGetDefault(ModelNode dataSourceNode, String key, Long defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asLong();
        }
        return defaultValue;
    }

    private Integer getIntIfSetOrGetDefault(ModelNode dataSourceNode, String key, Integer defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asInt();
        }
        return defaultValue;
    }

    private boolean getBooleanIfSetOrGetDefault(ModelNode dataSourceNode, String key, boolean defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asBoolean();
        }
        return defaultValue;
    }

    private String getStringIfSetOrGetDefault(ModelNode dataSourceNode, String key, String defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asString();
        }
        return defaultValue;
    }
}

