/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import org.jboss.as.connector.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.as.connector.adapters.jdbc.xa.XAManagedConnectionFactory;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.JdbcAdapterExtension;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.msc.service.StartException;

public class XaDataSourceService
extends AbstractDataSourceService {
    private final XaDataSource dataSourceConfig;

    public XaDataSourceService(String jndiName, XaDataSource dataSourceConfig) {
        super(jndiName);
        this.dataSourceConfig = dataSourceConfig;
    }

    @Override
    protected final BaseWrapperManagedConnectionFactory createManagedConnectionFactory(String jndiName, Driver driver) throws ResourceException, StartException {
        Validation validation;
        Statement statement;
        TimeOut timeOut;
        DsSecurity security;
        XAManagedConnectionFactory xaManagedConnectionFactory = new XAManagedConnectionFactory();
        try {
            Class<?> xaDataSourceClass = driver.getClass().getClassLoader().loadClass(this.dataSourceConfig.getXaDataSourceClass());
            xaManagedConnectionFactory.setXADataSourceClass(xaDataSourceClass);
        }
        catch (ClassNotFoundException e) {
            throw new StartException("Failed to load XA DataSource class - " + this.dataSourceConfig.getXaDataSourceClass());
        }
        xaManagedConnectionFactory.setJndiName(jndiName);
        xaManagedConnectionFactory.setSpy(true);
        if (this.dataSourceConfig.getNewConnectionSql() != null) {
            xaManagedConnectionFactory.setNewConnectionSQL(this.dataSourceConfig.getNewConnectionSql());
        }
        if (this.dataSourceConfig.getTransactionIsolation() != null) {
            xaManagedConnectionFactory.setTransactionIsolation(this.dataSourceConfig.getTransactionIsolation().name());
        }
        if (this.dataSourceConfig.getUrlDelimiter() != null) {
            xaManagedConnectionFactory.setURLDelimiter(this.dataSourceConfig.getUrlDelimiter());
        }
        if (this.dataSourceConfig.getUrlSelectorStrategyClassName() != null) {
            xaManagedConnectionFactory.setUrlSelectorStrategyClassName(this.dataSourceConfig.getUrlSelectorStrategyClassName());
        }
        if ((security = this.dataSourceConfig.getSecurity()) != null) {
            if (security.getUserName() != null) {
                xaManagedConnectionFactory.setUserName(security.getUserName());
            }
            if (security.getPassword() != null) {
                xaManagedConnectionFactory.setPassword(security.getPassword());
            }
        }
        if ((timeOut = this.dataSourceConfig.getTimeOut()) != null) {
            if (timeOut.getUseTryLock() != null) {
                xaManagedConnectionFactory.setUseTryLock(timeOut.getUseTryLock().intValue());
            }
            if (timeOut.getQueryTimeout() != null) {
                xaManagedConnectionFactory.setQueryTimeout(timeOut.getQueryTimeout().intValue());
            }
        }
        if ((statement = this.dataSourceConfig.getStatement()) != null) {
            if (statement.getTrackStatements() != null) {
                xaManagedConnectionFactory.setTrackStatements(statement.getTrackStatements().name());
            }
            if (statement.isSharePreparedStatements() != null) {
                xaManagedConnectionFactory.setSharePreparedStatements(statement.isSharePreparedStatements());
            }
            if (statement.getPreparedStatementsCacheSize() != null) {
                xaManagedConnectionFactory.setPreparedStatementCacheSize(statement.getPreparedStatementsCacheSize().intValue());
            }
        }
        if ((validation = this.dataSourceConfig.getValidation()) != null) {
            JdbcAdapterExtension staleConnectionChecker;
            JdbcAdapterExtension exceptionSorter;
            JdbcAdapterExtension validConnectionChecker;
            if (validation.isValidateOnMatch().booleanValue()) {
                xaManagedConnectionFactory.setValidateOnMatch(validation.isValidateOnMatch());
            }
            if (validation.getCheckValidConnectionSql() != null) {
                xaManagedConnectionFactory.setCheckValidConnectionSQL(validation.getCheckValidConnectionSql());
            }
            if ((validConnectionChecker = validation.getValidConnectionChecker()) != null) {
                if (validConnectionChecker.getClassName() != null) {
                    xaManagedConnectionFactory.setValidConnectionCheckerClassName(validConnectionChecker.getClassName());
                }
                if (validConnectionChecker.getConfigPropertiesMap() != null) {
                    xaManagedConnectionFactory.setValidConnectionCheckerProperties(this.buildConfigPropsString(validConnectionChecker.getConfigPropertiesMap()));
                }
            }
            if ((exceptionSorter = validation.getExceptionSorter()) != null) {
                if (exceptionSorter.getClassName() != null) {
                    xaManagedConnectionFactory.setExceptionSorterClassName(exceptionSorter.getClassName());
                }
                if (exceptionSorter.getConfigPropertiesMap() != null) {
                    xaManagedConnectionFactory.setExceptionSorterProperties(this.buildConfigPropsString(exceptionSorter.getConfigPropertiesMap()));
                }
            }
            if ((staleConnectionChecker = validation.getStaleConnectionChecker()) != null) {
                if (staleConnectionChecker.getClassName() != null) {
                    xaManagedConnectionFactory.setStaleConnectionCheckerClassName(staleConnectionChecker.getClassName());
                }
                if (staleConnectionChecker.getConfigPropertiesMap() != null) {
                    xaManagedConnectionFactory.setStaleConnectionCheckerProperties(this.buildConfigPropsString(staleConnectionChecker.getConfigPropertiesMap()));
                }
            }
        }
        return xaManagedConnectionFactory;
    }

    @Override
    protected Pool createPool(String jndiName, ManagedConnectionFactory mcf) {
        PoolConfiguration pc = this.createPoolConfiguration((CommonPool)this.dataSourceConfig.getXaPool(), (CommonTimeOut)this.dataSourceConfig.getTimeOut(), (CommonValidation)this.dataSourceConfig.getValidation());
        Boolean noTxSeparatePool = Boolean.FALSE;
        if (this.dataSourceConfig.getXaPool() != null && this.dataSourceConfig.getXaPool().isNoTxSeparatePool() != null) {
            noTxSeparatePool = this.dataSourceConfig.getXaPool().isNoTxSeparatePool();
        }
        PoolFactory pf = new PoolFactory();
        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
        String poolName = null;
        if (this.dataSourceConfig.getPoolName() != null) {
            poolName = this.dataSourceConfig.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        return pool;
    }

    @Override
    protected ConnectionManager createConnectionManager(String jndiName, Pool pool) {
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Boolean interleaving = null;
        Integer xaResourceTimeout = null;
        Boolean isSameRMOverride = null;
        Boolean wrapXAResource = null;
        Boolean padXid = null;
        if (this.dataSourceConfig.getTimeOut() != null) {
            allocationRetry = this.dataSourceConfig.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = this.dataSourceConfig.getTimeOut().getAllocationRetryWaitMillis();
            xaResourceTimeout = this.dataSourceConfig.getTimeOut().getXaResourceTimeout();
        }
        if (this.dataSourceConfig.getXaPool() != null) {
            interleaving = this.dataSourceConfig.getXaPool().isInterleaving();
            isSameRMOverride = this.dataSourceConfig.getXaPool().isSameRmOverride();
            wrapXAResource = this.dataSourceConfig.getXaPool().isWrapXaDataSource();
            padXid = this.dataSourceConfig.getXaPool().isPadXid();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, null, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        cm.setJndiName(jndiName);
        return cm;
    }
}

