/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import org.jboss.as.connector.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.as.connector.adapters.jdbc.local.LocalManagedConnectionFactory;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.JdbcAdapterExtension;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;

public class LocalDataSourceService
extends AbstractDataSourceService {
    private final DataSource dataSourceConfig;

    public LocalDataSourceService(String jndiName, DataSource dataSourceConfig) {
        super(jndiName);
        this.dataSourceConfig = dataSourceConfig;
    }

    @Override
    protected final BaseWrapperManagedConnectionFactory createManagedConnectionFactory(String jndiName, Driver driver) {
        Validation validation;
        Statement statement;
        TimeOut timeOut;
        DsSecurity security;
        LocalManagedConnectionFactory managedConnectionFactory = new LocalManagedConnectionFactory();
        managedConnectionFactory.setDriver(driver);
        managedConnectionFactory.setJndiName(jndiName);
        managedConnectionFactory.setSpy(true);
        if (this.dataSourceConfig.getConnectionProperties() != null) {
            managedConnectionFactory.setConnectionProperties(this.buildConfigPropsString(this.dataSourceConfig.getConnectionProperties()));
        }
        if (this.dataSourceConfig.getConnectionUrl() != null) {
            managedConnectionFactory.setConnectionURL(this.dataSourceConfig.getConnectionUrl());
        }
        if (this.dataSourceConfig.getNewConnectionSql() != null) {
            managedConnectionFactory.setNewConnectionSQL(this.dataSourceConfig.getNewConnectionSql());
        }
        if (this.dataSourceConfig.getTransactionIsolation() != null) {
            managedConnectionFactory.setTransactionIsolation(this.dataSourceConfig.getTransactionIsolation().name());
        }
        if (this.dataSourceConfig.getUrlDelimiter() != null) {
            managedConnectionFactory.setURLDelimiter(this.dataSourceConfig.getUrlDelimiter());
        }
        if (this.dataSourceConfig.getUrlSelectorStrategyClassName() != null) {
            managedConnectionFactory.setUrlSelectorStrategyClassName(this.dataSourceConfig.getUrlSelectorStrategyClassName());
        }
        if ((security = this.dataSourceConfig.getSecurity()) != null) {
            if (security.getUserName() != null) {
                managedConnectionFactory.setUserName(security.getUserName());
            }
            if (security.getPassword() != null) {
                managedConnectionFactory.setPassword(security.getPassword());
            }
        }
        if ((timeOut = this.dataSourceConfig.getTimeOut()) != null) {
            if (timeOut.getUseTryLock() != null) {
                managedConnectionFactory.setUseTryLock(timeOut.getUseTryLock().intValue());
            }
            if (timeOut.getQueryTimeout() != null) {
                managedConnectionFactory.setQueryTimeout(timeOut.getQueryTimeout().intValue());
            }
        }
        if ((statement = this.dataSourceConfig.getStatement()) != null) {
            if (statement.getTrackStatements() != null) {
                managedConnectionFactory.setTrackStatements(statement.getTrackStatements().name());
            }
            if (statement.isSharePreparedStatements() != null) {
                managedConnectionFactory.setSharePreparedStatements(statement.isSharePreparedStatements());
            }
            if (statement.getPreparedStatementsCacheSize() != null) {
                managedConnectionFactory.setPreparedStatementCacheSize(statement.getPreparedStatementsCacheSize().intValue());
            }
        }
        if ((validation = this.dataSourceConfig.getValidation()) != null) {
            JdbcAdapterExtension staleConnectionChecker;
            JdbcAdapterExtension exceptionSorter;
            JdbcAdapterExtension validConnectionChecker;
            if (validation.isValidateOnMatch().booleanValue()) {
                managedConnectionFactory.setValidateOnMatch(validation.isValidateOnMatch());
            }
            if (validation.getCheckValidConnectionSql() != null) {
                managedConnectionFactory.setCheckValidConnectionSQL(validation.getCheckValidConnectionSql());
            }
            if ((validConnectionChecker = validation.getValidConnectionChecker()) != null) {
                if (validConnectionChecker.getClassName() != null) {
                    managedConnectionFactory.setValidConnectionCheckerClassName(validConnectionChecker.getClassName());
                }
                if (validConnectionChecker.getConfigPropertiesMap() != null) {
                    managedConnectionFactory.setValidConnectionCheckerProperties(this.buildConfigPropsString(validConnectionChecker.getConfigPropertiesMap()));
                }
            }
            if ((exceptionSorter = validation.getExceptionSorter()) != null) {
                if (exceptionSorter.getClassName() != null) {
                    managedConnectionFactory.setExceptionSorterClassName(exceptionSorter.getClassName());
                }
                if (exceptionSorter.getConfigPropertiesMap() != null) {
                    managedConnectionFactory.setExceptionSorterProperties(this.buildConfigPropsString(exceptionSorter.getConfigPropertiesMap()));
                }
            }
            if ((staleConnectionChecker = validation.getStaleConnectionChecker()) != null) {
                if (staleConnectionChecker.getClassName() != null) {
                    managedConnectionFactory.setStaleConnectionCheckerClassName(staleConnectionChecker.getClassName());
                }
                if (staleConnectionChecker.getConfigPropertiesMap() != null) {
                    managedConnectionFactory.setStaleConnectionCheckerProperties(this.buildConfigPropsString(staleConnectionChecker.getConfigPropertiesMap()));
                }
            }
        }
        return managedConnectionFactory;
    }

    @Override
    protected Pool createPool(String jndiName, ManagedConnectionFactory mcf) {
        PoolConfiguration pc = this.createPoolConfiguration(this.dataSourceConfig.getPool(), (CommonTimeOut)this.dataSourceConfig.getTimeOut(), (CommonValidation)this.dataSourceConfig.getValidation());
        PoolFactory pf = new PoolFactory();
        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, false);
        String poolName = null;
        if (this.dataSourceConfig.getPoolName() != null) {
            poolName = this.dataSourceConfig.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        return pool;
    }

    @Override
    protected ConnectionManager createConnectionManager(String jndiName, Pool pool) {
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        if (this.dataSourceConfig.getTimeOut() != null) {
            allocationRetry = this.dataSourceConfig.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = this.dataSourceConfig.getTimeOut().getAllocationRetryWaitMillis();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, null, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), null, null, null, null, null);
        cm.setJndiName(jndiName);
        return cm;
    }
}

