/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.as.connector.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public abstract class AbstractDataSourceService
implements Service<AbstractDataSourceService>,
ManagedReferenceFactory {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.dsdeployer");
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"data-source"});
    private final InjectedValue<TransactionManagerService> transactionManagerValue = new InjectedValue();
    private final InjectedValue<Driver> driverValue = new InjectedValue();
    private final String jndiName;
    private DataSource sqlDataSource;
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    public AbstractDataSourceService(String jndiName) {
        this.jndiName = jndiName;
    }

    public synchronized ManagedReference getReference() {
        return new ValueManagedReference((Value)new ImmediateValue((Object)this.sqlDataSource));
    }

    public synchronized void start(StartContext startContext) throws StartException {
        try {
            BaseWrapperManagedConnectionFactory mcf = this.createManagedConnectionFactory(this.jndiName, (Driver)this.driverValue.getValue());
            Pool pool = this.createPool(this.jndiName, mcf);
            ConnectionManager cm = this.createConnectionManager(this.jndiName, pool);
            this.sqlDataSource = (DataSource)mcf.createConnectionFactory((javax.resource.spi.ConnectionManager)cm);
        }
        catch (Throwable t) {
            throw new StartException("Error during the deployment of " + this.jndiName, t);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        this.sqlDataSource = null;
    }

    public synchronized AbstractDataSourceService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Injector<TransactionManagerService> getTransactionManagerInjector() {
        return this.transactionManagerValue;
    }

    public Injector<Driver> getDriverInjector() {
        return this.driverValue;
    }

    protected abstract BaseWrapperManagedConnectionFactory createManagedConnectionFactory(String var1, Driver var2) throws ResourceException, StartException;

    protected abstract Pool createPool(String var1, ManagedConnectionFactory var2);

    protected abstract ConnectionManager createConnectionManager(String var1, Pool var2);

    protected PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    protected String buildConfigPropsString(Map<String, String> configProps) {
        StringBuffer valueBuf = new StringBuffer();
        for (Map.Entry<String, String> connProperty : configProps.entrySet()) {
            valueBuf.append(connProperty.getKey());
            valueBuf.append("=");
            valueBuf.append(connProperty.getValue());
            valueBuf.append(";");
        }
        return valueBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionManager getTransactionManager() {
        AccessController.doPrivileged(new SetContextLoaderAction(TransactionManagerService.class.getClassLoader()));
        try {
            TransactionManager transactionManager = ((TransactionManagerService)this.transactionManagerValue.getValue()).getTransactionManager();
            return transactionManager;
        }
        finally {
            AccessController.doPrivileged(CLEAR_ACTION);
        }
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }
}

