/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.connector;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.util.concurrent.Executor;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.bootstrap.DefaultBootStrapContextService;
import org.jboss.as.connector.deployers.RaDeploymentActivator;
import org.jboss.as.connector.subsystems.connector.ConnectorConfigService;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemConfiguration;
import org.jboss.as.connector.subsystems.connector.ParamsUtils;
import org.jboss.as.connector.workmanager.WorkManagerService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.bootstrapcontext.BaseCloneableBootstrapContext;
import org.jboss.jca.core.workmanager.WorkManagerImpl;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.JBossXATerminator;

class ConnectorSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    static final OperationHandler INSTANCE = new ConnectorSubsystemAdd();

    ConnectorSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        final String shortRunningThreadPool = operation.get("default-workmanager-short-running-thread-pool").asString();
        final String longRunningThreadPool = operation.get("default-workmanager-long-running-thread-pool").asString();
        boolean beanValidationEnabled = ParamsUtils.parseBooleanParameter(operation, "bean-validation-enabled", false);
        final boolean archiveValidationEnabled = ParamsUtils.parseBooleanParameter(operation, "archive-validation-enabled", false);
        final boolean failOnError = ParamsUtils.parseBooleanParameter(operation, "archive-validation-fail-on-error", true);
        final boolean failOnWarn = ParamsUtils.parseBooleanParameter(operation, "archive-validation-fail-on-warn", false);
        ModelNode model = context.getSubModel();
        if (shortRunningThreadPool != null) {
            model.get("default-workmanager-short-running-thread-pool").set(shortRunningThreadPool);
        }
        if (longRunningThreadPool != null) {
            model.get("default-workmanager-long-running-thread-pool").set(longRunningThreadPool);
        }
        if (ParamsUtils.has(operation, "bean-validation-enabled")) {
            model.get("bean-validation-enabled").set(beanValidationEnabled);
        }
        if (ParamsUtils.has(operation, "archive-validation-enabled")) {
            model.get("archive-validation-enabled").set(archiveValidationEnabled);
        }
        if (ParamsUtils.has(operation, "archive-validation-fail-on-error")) {
            model.get("archive-validation-fail-on-error").set(failOnError);
        }
        if (ParamsUtils.has(operation, "archive-validation-fail-on-warn")) {
            model.get("archive-validation-fail-on-warn").set(failOnWarn);
        }
        if (context instanceof BootOperationContext) {
            final BootOperationContext bootContext = (BootOperationContext)BootOperationContext.class.cast(context);
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    WorkManagerImpl wm = new WorkManagerImpl();
                    WorkManagerService wmService = new WorkManagerService((WorkManager)wm);
                    serviceTarget.addService(ConnectorServices.WORKMANAGER_SERVICE, (Service)wmService).addDependency(ThreadsServices.EXECUTOR.append(new String[]{shortRunningThreadPool}), Executor.class, wmService.getExecutorShortInjector()).addDependency(ThreadsServices.EXECUTOR.append(new String[]{longRunningThreadPool}), Executor.class, wmService.getExecutorLongInjector()).addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, wmService.getXaTerminatorInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    BaseCloneableBootstrapContext ctx = new BaseCloneableBootstrapContext();
                    DefaultBootStrapContextService defaultBootCtxService = new DefaultBootStrapContextService((CloneableBootstrapContext)ctx);
                    serviceTarget.addService(ConnectorServices.DEFAULT_BOOTSTRAP_CONTEXT_SERVICE, (Service)defaultBootCtxService).addDependency(ConnectorServices.WORKMANAGER_SERVICE, WorkManager.class, defaultBootCtxService.getWorkManagerValueInjector()).addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, defaultBootCtxService.getXaTerminatorInjector()).addDependency(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER, TransactionManagerService.class, defaultBootCtxService.getTxManagerInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    ConnectorSubsystemConfiguration config = new ConnectorSubsystemConfiguration();
                    config.setArchiveValidation(archiveValidationEnabled);
                    config.setArchiveValidationFailOnError(failOnError);
                    config.setArchiveValidationFailOnWarn(failOnWarn);
                    config.setBeanValidation(false);
                    ConnectorConfigService connectorConfigService = new ConnectorConfigService(config);
                    serviceTarget.addService(ConnectorServices.CONNECTOR_CONFIG_SERVICE, (Service)connectorConfigService).addDependency(ConnectorServices.DEFAULT_BOOTSTRAP_CONTEXT_SERVICE, CloneableBootstrapContext.class, connectorConfigService.getDefaultBootstrapContextInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    new RaDeploymentActivator().activate(bootContext, serviceTarget);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensating = new ModelNode();
        compensating.get("address").set(operation.require("address"));
        compensating.get("operation").set("remove");
        return new BasicOperationResult(compensating);
    }
}

