/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.deployment;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.List;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.TransactionManager;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.deployers.processors.ParsedRaDeploymentProcessor;
import org.jboss.as.connector.metadata.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.services.JndiService;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemConfiguration;
import org.jboss.as.connector.util.Injection;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.common.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public final class ResourceAdapterDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector");
    private final Module module;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private final Connector cmd;
    private final IronJacamar ijmd;
    private final InjectedValue<ConnectorSubsystemConfiguration> config = new InjectedValue();
    private final InjectedValue<TransactionManagerService> txm = new InjectedValue();
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    public ResourceAdapterDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, Connector cmd, IronJacamar ijmd, Module module) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        this.cmd = cmd;
        this.ijmd = ijmd;
        this.module = module;
    }

    public void start(StartContext context) throws StartException {
        ServiceContainer container = context.getController().getServiceContainer();
        AS7RaDeployer raDeployer = new AS7RaDeployer(container);
        raDeployer.setConfiguration((Configuration)this.config.getValue());
        URL url = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getUrl();
        String deploymentName = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getDeploymentName();
        File root = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getRoot();
        CommonDeployment raDeployment = null;
        try {
            raDeployment = raDeployer.doDeploy(url, deploymentName, root, (ClassLoader)this.module.getClassLoader(), this.cmd, this.ijmd);
        }
        catch (Throwable t) {
            throw new StartException("Failed to start RA deployment [" + deploymentName + "]", t);
        }
        this.value = new ResourceAdapterDeployment(this.module.getIdentifier(), raDeployment);
        ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
        log.debugf("Starting sevice %s", (Object)ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
    }

    @Override
    public void stop(StopContext context) {
        log.debugf("Stopping sevice %s", (Object)ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
        super.stop(context);
    }

    public InjectedValue<ConnectorSubsystemConfiguration> getConfig() {
        return this.config;
    }

    public InjectedValue<TransactionManagerService> getTxm() {
        return this.txm;
    }

    public Injector<TransactionManagerService> getTxmInjector() {
        return this.txm;
    }

    public Injector<ConnectorSubsystemConfiguration> getConfigInjector() {
        return this.config;
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }

    private class AS7RaDeployer
    extends AbstractResourceAdapterDeployer {
        private String deploymentName;
        private final ServiceContainer serviceContainer;

        public AS7RaDeployer(ServiceContainer serviceContainer) {
            super(true, ParsedRaDeploymentProcessor.log);
            this.serviceContainer = serviceContainer;
        }

        public CommonDeployment doDeploy(URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, IronJacamar ijmd) throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterDeploymentService.this.getConfig().getValue());
            this.deploymentName = deploymentName;
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(url, deploymentName, root, cl, cmd, ijmd);
            return dep;
        }

        public String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
            throw new IllegalStateException("Non-explicit JNDI bindings not supported");
        }

        public String[] bindConnectionFactory(URL url, String deployment, Object cf, String jndi) throws Throwable {
            JndiStrategy js = (JndiStrategy)ResourceAdapterDeploymentService.this.jndiStrategy.getValue();
            String[] result = js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
            ((MetadataRepository)ResourceAdapterDeploymentService.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), jndi);
            this.log.infof("Bound connection factory at %s", (Object)jndi);
            JndiService jndiService = new JndiService(cf, jndi);
            ServiceBuilder serviceBuilder = this.serviceContainer.addService(JndiService.SERVICE_NAME_BASE.append(new String[]{jndi}), (Service)jndiService).setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.install();
            return result;
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao) throws Throwable {
            throw new IllegalStateException("Non-explicit JNDI bindings not supported");
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao, String jndi) throws Throwable {
            JndiStrategy js = (JndiStrategy)ResourceAdapterDeploymentService.this.jndiStrategy.getValue();
            String[] result = js.bindAdminObjects(deployment, new Object[]{ao}, new String[]{jndi});
            ((MetadataRepository)ResourceAdapterDeploymentService.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), jndi);
            this.log.infof("Bound admin object at %s", (Object)jndi);
            JndiService jndiService = new JndiService(ao, jndi);
            ServiceBuilder serviceBuilder = this.serviceContainer.addService(JndiService.SERVICE_NAME_BASE.append(new String[]{jndi}), (Service)jndiService).setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.install();
            return result;
        }

        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            if (cmd != null && ijmd != null) {
                HashSet<String> raClasses = new HashSet<String>();
                HashSet<String> ijClasses = new HashSet<String>();
                if (cmd.getVersion() == Connector.Version.V_10) {
                    ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                    raClasses.add(ra10.getManagedConnectionFactoryClass().getValue());
                } else {
                    List cdMetas;
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                        for (ConnectionDefinition cdMeta : cdMetas) {
                            raClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                        }
                    }
                }
                if (raClasses.size() == 0) {
                    return false;
                }
                if (ijmd.getConnectionDefinitions() != null) {
                    for (CommonConnDef def : ijmd.getConnectionDefinitions()) {
                        String clz = def.getClassName();
                        if (clz == null && raClasses.size() == 1) {
                            return true;
                        }
                        if (clz == null) continue;
                        ijClasses.add(clz);
                    }
                }
                for (String clz : raClasses) {
                    if (ijClasses.contains(clz)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        protected boolean checkConfigurationIsValid() {
            return this.getConfiguration() != null;
        }

        protected PrintWriter getLogPrintWriter() {
            return new PrintWriter(System.out);
        }

        protected File getReportDirectory() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TransactionManager getTransactionManager() {
            AccessController.doPrivileged(new SetContextLoaderAction(TransactionManagerService.class.getClassLoader()));
            try {
                TransactionManager transactionManager = ((TransactionManagerService)ResourceAdapterDeploymentService.this.getTxm().getValue()).getTransactionManager();
                return transactionManager;
            }
            finally {
                AccessController.doPrivileged(CLEAR_ACTION);
            }
        }

        public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
            try {
                Class<?> clz = Class.forName(className, true, cl);
                Object o = clz.newInstance();
                if (configs != null) {
                    Injection injector = new Injection();
                    for (ConfigProperty configProperty : configs) {
                        ConfigProperty16 cpmd16;
                        if (!configProperty.isValueSet()) continue;
                        boolean setValue = true;
                        if (configProperty instanceof ConfigProperty16 && (cpmd16 = (ConfigProperty16)configProperty).getConfigPropertyIgnore() != null && cpmd16.getConfigPropertyIgnore().booleanValue()) {
                            setValue = false;
                        }
                        if (!setValue) continue;
                        injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                    }
                }
                return o;
            }
            catch (Throwable t) {
                throw new DeployException("Deployment " + className + " failed", t);
            }
        }

        protected void registerResourceAdapterToMDR(URL url, File file, Connector connector, IronJacamar ij) throws AlreadyExistsException {
            this.log.debugf("Registering ResourceAdapter %s", (Object)this.deploymentName);
            ((MetadataRepository)ResourceAdapterDeploymentService.this.mdr.getValue()).registerResourceAdapter(this.deploymentName, file, connector, ij);
        }

        protected String registerResourceAdapterToResourceAdapterRepository(ResourceAdapter instance) {
            return ((ResourceAdapterRepository)ResourceAdapterDeploymentService.this.raRepository.getValue()).registerResourceAdapter(instance);
        }

        protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
            return null;
        }
    }
}

