/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class RarDependencyProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier JAVAX_ID = ModuleIdentifier.create((String)"javax.resource.api");
    private static ModuleIdentifier LOGGING_ID = ModuleIdentifier.create((String)"org.jboss.logging");
    private static ModuleIdentifier IRON_JACAMAR_ID = ModuleIdentifier.create((String)"org.jboss.ironjacamar.api");
    private static ModuleIdentifier IRON_JACAMAR_IMPL_ID = ModuleIdentifier.create((String)"org.jboss.ironjacamar.impl");
    private static ModuleIdentifier NAMING_ID = ModuleIdentifier.create((String)"org.jboss.as.naming");
    private static ModuleIdentifier VALIDATION_ID = ModuleIdentifier.create((String)"javax.validation.api");
    private static ModuleIdentifier HIBERNATE_VALIDATOR_ID = ModuleIdentifier.create((String)"org.hibernate.validator");
    private static ModuleIdentifier COMMON_CORE_ID = ModuleIdentifier.create((String)"org.jboss.common-core");
    private static ModuleIdentifier RESOURCE_API_ID = ModuleIdentifier.create((String)"javax.resource.api");
    private static ModuleIdentifier SYSTEM_ID = ModuleIdentifier.create((String)"javax.api");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        if (phaseContext.getDeploymentUnit().getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY) == null) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, JAVAX_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, LOGGING_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, IRON_JACAMAR_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, IRON_JACAMAR_IMPL_ID, false, true, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, SYSTEM_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, NAMING_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, VALIDATION_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, HIBERNATE_VALIDATOR_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, COMMON_CORE_ID, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, RESOURCE_API_ID, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

