/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.util.Map;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.annotations.repository.jandex.JandexAnnotationRepositoryImpl;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeploymentService;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemConfiguration;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.txn.TxnServices;
import org.jboss.jandex.Index;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class ParsedRaDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.radeployer");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)phaseContext.getDeploymentUnit().getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        if (connectorXmlDescriptor == null) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        IronJacamarXmlDescriptor ironJacamarXmlDescriptor = (IronJacamarXmlDescriptor)deploymentUnit.getAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Failed to get module attachment for " + phaseContext.getDeploymentUnit());
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        Connector cmd = connectorXmlDescriptor != null ? connectorXmlDescriptor.getConnector() : null;
        IronJacamar ijmd = ironJacamarXmlDescriptor != null ? ironJacamarXmlDescriptor.getIronJacamar() : null;
        try {
            Annotations annotator = new Annotations();
            Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
            for (Map.Entry entry : indexes.entrySet()) {
                JandexAnnotationRepositoryImpl repository = new JandexAnnotationRepositoryImpl((Index)entry.getValue(), (ClassLoader)classLoader);
                cmd = annotator.merge(cmd, (AnnotationRepository)repository, (ClassLoader)classLoader);
            }
            if (cmd != null) {
                cmd.validate();
                cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)ijmd, cmd);
            }
            ResourceAdapterDeploymentService raDeployementService = new ResourceAdapterDeploymentService(connectorXmlDescriptor, cmd, ijmd, module);
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()}), (Service)raDeployementService).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, raDeployementService.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, raDeployementService.getRaRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, raDeployementService.getRegistryInjector()).addDependency(ConnectorServices.JNDI_STRATEGY_SERVICE, JndiStrategy.class, raDeployementService.getJndiInjector()).addDependency(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER, TransactionManagerService.class, raDeployementService.getTxmInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, ConnectorSubsystemConfiguration.class, raDeployementService.getConfigInjector()).addDependency(NamingService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

