/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.adapters.jdbc.extensions.mssql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.as.connector.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.logging.Logger;

public class MSSQLValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final String QUERY = "SELECT 1";
    private static Logger log = Logger.getLogger(MSSQLValidConnectionChecker.class);
    private static final long serialVersionUID = 3995516551833725723L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLException isValidConnection(Connection c) {
        SQLException sqe = null;
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            stmt.execute(QUERY);
        }
        catch (SQLException e) {
            log.warn((Object)"warning: connection validation failed for current managed connection.");
            sqe = e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                log.warn((Object)"simple close failed for managed connection", (Throwable)e);
            }
        }
        return sqe;
    }
}

