/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.configadmin.parser.ConfigAdminExtension;
import org.jboss.as.configadmin.parser.ConfigAdminProviders;
import org.jboss.as.configadmin.service.ConfigAdminService;
import org.jboss.as.configadmin.service.ConfigAdminServiceImpl;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ConfigurationAdd
extends AbstractAddStepHandler {
    static final ConfigurationAdd INSTANCE = new ConfigurationAdd();
    private InitializeConfigAdminService initializationService;
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = ConfigAdminProviders.getResourceBundle(locale);
            node.get("operation-name").set("add");
            node.get("description").set(resbundle.getString("configuration.add"));
            node.get(new String[]{"request-properties", "entries", "description"}).set(resbundle.getString("configuration.entries"));
            node.get(new String[]{"request-properties", "entries", "type"}).set(ModelType.LIST);
            node.get(new String[]{"request-properties", "entries", "required"}).set(true);
            node.get(new String[]{"request-properties", "entries", "value-type"}).set(ModelType.PROPERTY);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private ConfigurationAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.get("entries").set(operation.get("entries"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode entries = operation.get("entries");
        String pid = operation.get("address").asObject().get("configuration").asString();
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (String key : entries.keys()) {
            ((Dictionary)dictionary).put(key, entries.get(key).asString());
        }
        ConfigAdminServiceImpl configAdmin = ConfigAdminExtension.getConfigAdminService(context);
        if (configAdmin != null) {
            configAdmin.putConfigurationFromDMR(pid, dictionary);
        } else {
            ConfigurationAdd configurationAdd = this;
            synchronized (configurationAdd) {
                if (this.initializationService == null) {
                    this.initializationService = new InitializeConfigAdminService();
                    ServiceBuilder builder = context.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"configadmin", "data_initialization"}), (Service)this.initializationService);
                    builder.addDependency(ConfigAdminService.SERVICE_NAME, ConfigAdminService.class, (Injector)this.initializationService.injectedConfigAdminService);
                    builder.install();
                }
            }
            this.initializationService.putConfiguration(pid, dictionary);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String pid = operation.get("address").asObject().get("configuration").asString();
        ConfigAdminServiceImpl configAdmin = ConfigAdminExtension.getConfigAdminService(context);
        if (configAdmin != null) {
            configAdmin.removeConfigurationFromDMR(pid);
        }
    }

    static class InitializeConfigAdminService
    implements Service<Object> {
        private final Map<String, Dictionary<String, String>> configs = new ConcurrentHashMap<String, Dictionary<String, String>>();
        private final InjectedValue<ConfigAdminService> injectedConfigAdminService = new InjectedValue();

        InitializeConfigAdminService() {
        }

        public Object getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        public void putConfiguration(String pid, Dictionary<String, String> dictionary) {
            this.configs.put(pid, dictionary);
        }

        public void start(StartContext context) throws StartException {
            for (Map.Entry<String, Dictionary<String, String>> entry : this.configs.entrySet()) {
                ConfigAdminServiceImpl configAdminService = (ConfigAdminServiceImpl)this.injectedConfigAdminService.getValue();
                configAdminService.putConfigurationFromDMR(entry.getKey(), entry.getValue());
            }
        }

        public void stop(StopContext context) {
        }
    }
}

