/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.protocol.jmx;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.protocol.jmx.AbstractJMXProtocol;
import org.jboss.as.arquillian.protocol.jmx.JMXProtocolAS7;
import org.jboss.as.arquillian.protocol.jmx.ManifestUtils;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.arquillian.service.JMXProtocolEndpointExtension;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.ManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class JMXProtocolPackager
implements DeploymentPackager {
    private static final List<String> defaultDependencies = new ArrayList<String>();
    private static final Logger log;
    private JMXProtocolAS7.ServiceArchiveHolder archiveHolder;

    JMXProtocolPackager(JMXProtocolAS7.ServiceArchiveHolder archiveHolder) {
        this.archiveHolder = archiveHolder;
    }

    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> protocolProcessors) {
        Archive appArchive = testDeployment.getApplicationArchive();
        if (this.archiveHolder.getArchive() == null) {
            Collection auxArchives = testDeployment.getAuxiliaryArchives();
            JavaArchive archive = this.generateArquillianServiceArchive(auxArchives);
            this.archiveHolder.setArchive((Archive<?>)archive);
        }
        this.addModulesManifestDependencies(appArchive);
        this.archiveHolder.addPreparedDeployment(appArchive);
        return appArchive;
    }

    private JavaArchive generateArquillianServiceArchive(Collection<Archive<?>> auxArchives) {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-service");
        log.debugf("Generating: %s", (Object)archive.getName());
        archive.addPackage(ArquillianService.class.getPackage());
        archive.addPackage(AbstractJMXProtocol.class.getPackage());
        final HashSet<String> loadableExtensions = new HashSet<String>();
        String loadableExtentionsPath = "META-INF/services/" + RemoteLoadableExtension.class.getName();
        for (Archive<?> aux : auxArchives) {
            Node node = aux.get(loadableExtentionsPath);
            if (node != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(node.getAsset().openStream()));
                try {
                    String line = br.readLine();
                    while (line != null) {
                        loadableExtensions.add(line);
                        line = br.readLine();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            log.debugf("Merging archive: %s", aux);
            archive.merge(aux);
        }
        loadableExtensions.add(JMXProtocolEndpointExtension.class.getName());
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = ManifestBuilder.newInstance();
                StringBuffer dependencies = new StringBuffer();
                dependencies.append("org.jboss.as.jmx,");
                dependencies.append("org.jboss.as.server,");
                dependencies.append("org.jboss.as.osgi,");
                dependencies.append("org.jboss.jandex,");
                dependencies.append("org.jboss.logging,");
                dependencies.append("org.jboss.modules,");
                dependencies.append("org.jboss.msc,");
                dependencies.append("org.jboss.osgi.framework,");
                dependencies.append("org.osgi.core");
                builder.addManifestHeader("Dependencies", dependencies.toString());
                return builder.openStream();
            }
        });
        String serviceActivatorPath = "META-INF/services/" + ServiceActivator.class.getName();
        URL serviceActivatorURL = this.getClass().getClassLoader().getResource("arquillian-service/" + serviceActivatorPath);
        if (serviceActivatorURL == null) {
            throw new RuntimeException("No arquillian-service/" + serviceActivatorPath + " found by classloader: " + this.getClass().getClassLoader());
        }
        archive.addAsResource((Asset)new UrlAsset(serviceActivatorURL), serviceActivatorPath);
        StringBuffer props = new StringBuffer("Bundle-SymbolicName: " + archive.getName() + "\n");
        props.append("Export-Package: ");
        props.append("org.jboss.arquillian.container.test.api,org.jboss.arquillian.junit,org.jboss.arquillian.osgi,org.jboss.arquillian.test.api,");
        props.append("org.jboss.osgi.testing,");
        props.append("org.jboss.shrinkwrap.api,org.jboss.shrinkwrap.api.asset,org.jboss.shrinkwrap.api.spec,");
        props.append("org.junit,org.junit.runner,javax.inject,org.osgi.framework");
        archive.add((Asset)new StringAsset(props.toString()), "META-INF/jbosgi-xservice.properties");
        archive.delete(ArchivePaths.create((String)loadableExtentionsPath));
        archive.addAsResource(new Asset(){

            public InputStream openStream() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
                for (String line : loadableExtensions) {
                    pw.println(line);
                }
                pw.close();
                return new ByteArrayInputStream(baos.toByteArray());
            }
        }, loadableExtentionsPath);
        log.debugf("Loadable extensions: %s", loadableExtensions);
        log.tracef("Archive content: %s\n%s", (Object)archive, (Object)archive.toString(true));
        return archive;
    }

    private void addModulesManifestDependencies(Archive<?> appArchive) {
        String value;
        if (!(appArchive instanceof ManifestContainer)) {
            throw new IllegalArgumentException("ManifestContainer expected " + appArchive);
        }
        final Manifest manifest = ManifestUtils.getOrCreateManifest(appArchive);
        if (BundleInfo.isValidBundleManifest((Manifest)manifest)) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION.toString()) == null) {
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        }
        StringBuffer moduleDeps = new StringBuffer((value = attributes.getValue("Dependencies")) != null && value.trim().length() > 0 ? value : "org.jboss.modules");
        for (String dep : defaultDependencies) {
            if (moduleDeps.indexOf(dep) >= 0) continue;
            moduleDeps.append("," + dep);
        }
        log.debugf("Add dependencies: %s", (Object)moduleDeps);
        attributes.putValue("Dependencies", moduleDeps.toString());
        ArchivePath manifestPath = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
        appArchive.delete(manifestPath);
        appArchive.add(new Asset(){

            public InputStream openStream() {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    return new ByteArrayInputStream(baos.toByteArray());
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot write manifest", ex);
                }
            }
        }, manifestPath);
    }

    static {
        defaultDependencies.add("deployment.arquillian-service");
        defaultDependencies.add("org.jboss.modules");
        defaultDependencies.add("org.jboss.msc");
        log = Logger.getLogger(JMXProtocolPackager.class);
    }
}

