/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.protocol.jmx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.as.arquillian.protocol.jmx.JMXProtocolAS7;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;

public class ArquillianServiceDeployer {
    private static final Logger log = Logger.getLogger(ArquillianServiceDeployer.class);
    @Inject
    @SuiteScoped
    private Instance<JMXProtocolAS7.ServiceArchiveHolder> archiveHolderInst;
    @Inject
    @ContainerScoped
    private Instance<Container> containerInst;
    private AtomicBoolean serviceArchiveDeployed = new AtomicBoolean();

    public synchronized void doServiceDeploy(@Observes BeforeDeploy event) {
        JMXProtocolAS7.ServiceArchiveHolder archiveHolder = (JMXProtocolAS7.ServiceArchiveHolder)this.archiveHolderInst.get();
        if (archiveHolder != null && !this.serviceArchiveDeployed.get()) {
            Archive<?> archive = archiveHolder.getArchive();
            if (this.isArquillianServiceDeployed(archive)) {
                this.undeployArquillianService(archive);
            }
            try {
                log.infof("Deploy arquillian service: %s", archive);
                DeployableContainer deployableContainer = ((Container)this.containerInst.get()).getDeployableContainer();
                deployableContainer.deploy(archive);
                this.serviceArchiveDeployed.set(true);
            }
            catch (Throwable th) {
                log.error((Object)"Cannot deploy arquillian service", th);
            }
        }
    }

    public synchronized void undeploy(@Observes BeforeStop event) {
        JMXProtocolAS7.ServiceArchiveHolder archiveHolder = (JMXProtocolAS7.ServiceArchiveHolder)this.archiveHolderInst.get();
        if (archiveHolder != null && this.serviceArchiveDeployed.get()) {
            try {
                Archive<?> archive = archiveHolder.getArchive();
                log.infof("Undeploy arquillian service: %s", archive);
                DeployableContainer deployableContainer = ((Container)this.containerInst.get()).getDeployableContainer();
                deployableContainer.undeploy(archive);
                this.serviceArchiveDeployed.set(false);
            }
            catch (Throwable th) {
                log.error((Object)"Cannot undeploy arquillian service", th);
            }
        }
    }

    private boolean isArquillianServiceDeployed(Archive<?> archive) {
        try {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-children-names");
            operation.get("child-type").set("deployment");
            ModelNode result = this.getModelControllerClient().execute(operation);
            if ("failed".equals(result.get("outcome").asString())) {
                throw new IllegalStateException("Management request failed: " + result);
            }
            boolean serviceFound = false;
            List nodeList = result.get("result").asList();
            for (ModelNode node : nodeList) {
                if (!node.asString().equals(archive.getName())) continue;
                log.infof("Found already deployed arquillian service: %s", (Object)node);
                serviceFound = true;
                break;
            }
            return serviceFound;
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot determine whether arquillian service is deployed", new Object[0]);
            return false;
        }
    }

    private void undeployArquillianService(Archive<?> archive) {
        try {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("composite");
            operation.get("address").setEmptyList();
            ModelNode steps = operation.get("steps");
            ModelNode undeployNode = new ModelNode();
            undeployNode.get("operation").set("undeploy");
            undeployNode.get("address").set("deployment", archive.getName());
            steps.add(undeployNode);
            ModelNode removeNode = new ModelNode();
            removeNode.get("operation").set("remove");
            removeNode.get("address").set("deployment", archive.getName());
            steps.add(removeNode);
            log.infof("Undeploying arquillian service  with: %s", (Object)operation);
            ModelNode result = this.getModelControllerClient().execute(operation);
            if ("failed".equals(result.get("outcome").asString())) {
                log.errorf("Management request failed: %s", (Object)result);
            }
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot undeploy arquillian service", new Object[0]);
        }
    }

    private ModelControllerClient getModelControllerClient() throws UnknownHostException {
        return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("127.0.0.1"), (int)9999);
    }
}

