/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import org.jboss.as.appclient.component.ApplicationClientComponentDescription;
import org.jboss.as.appclient.deployment.AppClientAttachments;
import org.jboss.as.appclient.logging.AppClientMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.appclient.spec.AppClientEnvironmentRefsGroupMetaData;
import org.jboss.metadata.appclient.spec.ApplicationClientMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

public class ApplicationClientDescriptorMethodProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
        if (eeModuleDescription != null) {
            for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
                if (!(component instanceof ApplicationClientComponentDescription)) continue;
                try {
                    this.handleApplicationClient((ApplicationClientComponentDescription)component, classIndex, reflectionIndex, deploymentUnit);
                }
                catch (ClassNotFoundException e) {
                    throw AppClientMessages.MESSAGES.cannotLoadComponentClass(e);
                }
            }
        }
    }

    private void handleApplicationClient(ApplicationClientComponentDescription component, DeploymentClassIndex classIndex, DeploymentReflectionIndex reflectionIndex, DeploymentUnit deploymentUnit) throws ClassNotFoundException, DeploymentUnitProcessingException {
        LifecycleCallbacksMetaData preDestroys;
        ApplicationClientMetaData metaData = (ApplicationClientMetaData)deploymentUnit.getAttachment(AppClientAttachments.APPLICATION_CLIENT_META_DATA);
        if (metaData == null) {
            return;
        }
        AppClientEnvironmentRefsGroupMetaData environment = metaData.getEnvironmentRefsGroupMetaData();
        if (environment == null) {
            return;
        }
        ClassIndex componentClass = classIndex.classIndex(component.getComponentClassName());
        LifecycleCallbacksMetaData postConstructs = environment.getPostConstructs();
        if (postConstructs != null) {
            for (LifecycleCallbackMetaData postConstruct : postConstructs) {
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = postConstruct.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                builder.setPostConstruct(methodIdentifier);
                if (postConstruct.getClassName() == null || postConstruct.getClassName().isEmpty()) {
                    String className = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)methodIdentifier).getDeclaringClass().getName();
                    component.addInterceptorMethodOverride(className, builder.build());
                    continue;
                }
                component.addInterceptorMethodOverride(postConstruct.getClassName(), builder.build());
            }
        }
        if ((preDestroys = environment.getPreDestroys()) != null) {
            for (LifecycleCallbackMetaData preDestroy : preDestroys) {
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = preDestroy.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                builder.setPreDestroy(methodIdentifier);
                if (preDestroy.getClassName() == null || preDestroy.getClassName().isEmpty()) {
                    String className = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)methodIdentifier).getDeclaringClass().getName();
                    component.addInterceptorMethodOverride(className, builder.build());
                    continue;
                }
                component.addInterceptorMethodOverride(preDestroy.getClassName(), builder.build());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

