/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.config.DomainConfigEntryPoint;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class LoggingPage
extends ConfigurationPage
implements Navigatable {
    @Override
    public ConfigFragment getConfigFragment() {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-tabpanel"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }

    public ConfigFragment getWindowFragment() {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-window-content"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }

    public void removeInTable(String name) {
        this.getResourceManager().getResourceTable().selectRowByText(0, name);
        this.clickButton("Remove");
        Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirmAndDismissReloadRequiredMessage();
    }

    public void addLogger(String name, String category, String level) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().select("level", level);
        this.getWindowFragment().getEditor().checkbox("use-parent-handlers", true);
        this.getWindowFragment().clickButton("Save");
    }

    public void addFormatter(String name) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().clickButton("Save");
    }

    public void addAsyncHandler(String name, String queueLen) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("queue-length", queueLen);
        this.getWindowFragment().clickButton("Save");
    }

    public void addFileHandler(String name, String path) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().clickButton("Next");
        this.getWindowFragment().getEditor().text("path", path);
        this.getWindowFragment().getEditor().clickButton("Finish");
    }

    public void addSyslogHandler(String name) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().clickButton("Save");
    }

    public void addConsoleHandler(String name, String level) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().select("level", level);
        this.getWindowFragment().clickButton("Save");
    }

    public void addPeriodicSizeHandler(String name, String suffix, String path) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("suffix", suffix);
        this.getWindowFragment().clickButton("Next");
        this.getWindowFragment().getEditor().text("path", path);
        this.getWindowFragment().getEditor().clickButton("Finish");
    }

    public void addCustomFormatter(String name, String clazz, String module) {
        this.clickButton("Add");
        this.getWindowFragment().getEditor().text("name", name);
        this.getWindowFragment().getEditor().text("class", clazz);
        this.getWindowFragment().getEditor().text("module", module);
        this.getWindowFragment().clickButton("Save");
    }

    public void switchToHandlerTab() {
        String label = PropUtils.get("config.core.logging.handler.tab.label");
        this.switchTab(label);
    }

    public void switchToCategoriesTab() {
        this.switchTab("Log Categories");
    }

    public void switchToFormatterTab() {
        this.switchTab("Formatter");
    }

    public void switchToFile() {
        this.switchView("File");
    }

    public void switchToPeriodic() {
        this.switchView("Periodic");
    }

    public void switchToSize() {
        WebElement viewPanel = this.browser.findElement(By.className((String)"paged-view-navigation-container"));
        WebElement editLink = viewPanel.findElement(By.linkText((String)"Size"));
        editLink.click();
    }

    public void switchToSyslog() {
        this.switchView("Syslog");
    }

    public void switchToCustomPattern() {
        this.switchSubTab("Custom");
    }

    public void switchToPeriodicSize() {
        String label = PropUtils.get("config.core.logging.periodic_size.view.label");
        this.switchView(label);
    }

    public void switchToAsync() {
        WebElement viewPanel = this.browser.findElement(By.className((String)"paged-view-navigation-container"));
        WebElement editLink = viewPanel.findElement(By.linkText((String)"Async"));
        editLink.click();
    }

    public boolean save() {
        this.clickButton(PropUtils.get("configarea.save.button.label"));
        try {
            Graphene.waitModel().until().element(this.getEditButton()).is().visible();
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public Editor edit() {
        WebElement button = this.getEditButton();
        button.click();
        ((IsElementBuilder)Graphene.waitGui().until().element(button).is().not()).visible();
        return this.getConfig().getEditor();
    }

    private WebElement getEditButton() {
        ByJQuery selector = ByJQuery.selector((String)("." + PropUtils.get("configarea.edit.button.class") + ":visible"));
        return this.getContentRoot().findElement((By)selector);
    }

    public void checkbox(String identifier, boolean value) throws InterruptedException {
        String byIdSelector = "input[type='checkbox'][id$='" + identifier + "']";
        String byNameSelector = "input[type='checkbox'][name='" + identifier + "']";
        String byParentTdIdSelector = "td[id*='" + identifier + "'] input[type='checkbox']:visible";
        String selectorString = byIdSelector + ", " + byNameSelector + ", " + byParentTdIdSelector;
        System.out.println(selectorString);
        ByJQuery selector = ByJQuery.selector((String)selectorString);
        WebElement input = Console.withBrowser(this.browser).findElement((By)selector, this.getContentRoot());
        boolean current = input.isSelected();
        if (value != current) {
            input.click();
        }
        if (value) {
            Graphene.waitGui().until().element(input).is().selected();
        } else {
            ((IsElementBuilder)Graphene.waitGui().until().element(input).is().not()).selected();
        }
    }

    public void select(String identifier, String value) {
        String byIdSelector = "select[id$='" + identifier + "']";
        String byNameSelector = "select[name='" + identifier + "']";
        String byParentTdIdSelector = "td[id*='" + identifier + "'] select:visible";
        ByJQuery selector = ByJQuery.selector((String)(byIdSelector + ", " + byNameSelector + ", " + byParentTdIdSelector));
        WebElement selectElement = Console.withBrowser(this.browser).findElement((By)selector, this.getContentRoot());
        Select select = new Select(selectElement);
        select.selectByVisibleText(value);
    }

    @Override
    public void navigate() {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigEntryPoint.class).step("Configuration", "Profiles").step("Profile", ConfigUtils.getDefaultProfile()).step("Subsystem", "Logging") : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems").step("Subsystem", "Logging");
        Row row = navigation.selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke("View");
        Application.waitUntilVisible();
    }

    public void selectLogger(String name) {
        this.getResourceManager().getResourceTable().selectRowByText(0, name);
    }

    public void selectFormatter(String name) {
        this.getResourceManager().getResourceTable().selectRowByText(0, name);
    }

    public void selectHandler(String name) {
        this.getResourceManager().getResourceTable().selectRowByText(0, name);
    }
}

