/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.DomainConfigEntryPoint;
import org.jboss.hal.testsuite.page.config.MessagingPage;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;

public class JMSBridgePage
extends MessagingPage
implements Navigatable {
    @Override
    public void navigate() {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigEntryPoint.class).step("Configuration", "Profiles").step("Profile", ConfigUtils.getDefaultProfile()) : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        navigation.step("Subsystem", "Messaging - ActiveMQ").step("Settings", "JMS Bridge").selectRow().invoke("View");
        Application.waitUntilVisible();
    }

    public void removeJMSBridge(String bridgeName) {
        this.selectInTable(bridgeName);
        this.clickButton("Remove");
        Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class).confirm();
    }

    public void switchToSourceContext() {
        this.getConfig().getTabByLabel("Source Context").click();
    }

    public void switchToTargetContext() {
        this.getConfig().getTabByLabel("Target Context").click();
    }

    public void switchToTargetCredentialReference() {
        this.getConfig().getTabByLabel("Target Credential Reference").click();
    }

    public void switchToSourceCredentialReference() {
        this.getConfig().getTabByLabel("Source Credential Reference").click();
    }

    public WizardWindow openAddContextPropertyWindow() {
        this.getConfig().clickButton("Add");
        return Console.withBrowser(this.browser).openedWindow(WizardWindow.class);
    }

    public void selectJMSBridgeInTable(String jmsBridgeName) {
        this.getResourceManager().getResourceTable().selectRowByText(0, jmsBridgeName);
    }

    public ConfirmationWindow selectContextParameterAndClickRemove(String contextParameterKey) {
        ((ResourceTableRowFragment)this.getConfig().getResourceTable().getRowByText(0, contextParameterKey)).click();
        this.getConfig().clickButton("Remove");
        return Console.withBrowser(this.browser).openedWindow(ConfirmationWindow.class);
    }
}

