/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.util;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.WindowFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.ConfirmationWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManager
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(ResourceManager.class);
    private static final By RHS_CONTENT_PANEL_SELECTOR = ByJQuery.selector((String)".rhs-content-panel:visible");
    private static final By BOTTOM_CONFIG_SELECTOR = ByJQuery.selector((String)"table.fill-layout-width:visible");
    private static final By WIZARD_TABLE_SELECTOR = ByJQuery.selector((String)".default-cell-table.master_detail-master");
    private static final By POPUP_LAYOUT_WIDTH_SELECTOR = ByJQuery.selector((String)"table.fill-popupLayout-width:visible");

    public ResourceTableFragment getResourceTable() {
        WebElement tableRoot;
        if (!this.getRoot().findElements(RHS_CONTENT_PANEL_SELECTOR).isEmpty()) {
            log.debug("Found table at top of page!");
            tableRoot = this.getRoot().findElement(RHS_CONTENT_PANEL_SELECTOR);
        } else if (!this.getRoot().findElements(BOTTOM_CONFIG_SELECTOR).isEmpty()) {
            log.debug("Found table in config!");
            tableRoot = this.getRoot().findElement(BOTTOM_CONFIG_SELECTOR);
        } else if (this.root.getAttribute("class").equals("default-window") && !this.getRoot().findElements(WIZARD_TABLE_SELECTOR).isEmpty()) {
            log.debug("Found table in wizard!");
            tableRoot = this.getRoot().findElement(WIZARD_TABLE_SELECTOR);
        } else if (!this.getRoot().findElements(POPUP_LAYOUT_WIDTH_SELECTOR).isEmpty()) {
            log.debug("Found table using non-standard selector '{}'!", (Object)POPUP_LAYOUT_WIDTH_SELECTOR.toString());
            tableRoot = this.getRoot().findElement(POPUP_LAYOUT_WIDTH_SELECTOR);
        } else {
            throw new NotFoundException("No resource table was found within specified root!");
        }
        return (ResourceTableFragment)Graphene.createPageFragment(ResourceTableFragment.class, (WebElement)tableRoot);
    }

    public ResourceTableRowFragment selectByName(String name) {
        return this.getResourceTable().selectRowByText(0, name);
    }

    public <T extends WizardWindow> T addResource(Class<T> clazz, String label) {
        this.clickButton(label);
        return Console.withBrowser(this.browser).openedWizard(clazz);
    }

    public <T extends WizardWindow> T addResource(Class<T> clazz) {
        String label = PropUtils.get("config.shared.add.label");
        return this.addResource(clazz, label);
    }

    public WizardWindow addResource() {
        return this.addResource(WizardWindow.class);
    }

    public <T extends WindowFragment> T removeResource(String name, Class<T> clazz) {
        this.selectByName(name);
        String label = PropUtils.get("config.shared.remove.label");
        this.clickButton(label);
        return Console.withBrowser(this.browser).openedWindow(clazz);
    }

    public ConfirmationWindow removeResource(String name) {
        return this.removeResource(name, ConfirmationWindow.class);
    }

    public void removeResourceAndConfirm(String name) {
        ConfirmationWindow confirmationWindow = this.removeResource(name, ConfirmationWindow.class);
        confirmationWindow.confirm();
    }

    public void viewByName(String name) {
        ResourceTableRowFragment row = this.selectByName(name);
        row.view();
    }

    public List<String> listResources() {
        return this.getResourceTable().getTextInColumn(0);
    }

    public boolean isResourcePresent(String name) {
        try {
            Graphene.waitModel((WebDriver)this.browser).pollingEvery(100L, TimeUnit.MILLISECONDS).withTimeout(2000L, TimeUnit.MILLISECONDS).until(input -> this.getResourceTable().getRowByText(0, name) != null);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

