/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.modal.suggestbox;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.PopUpFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.suggestbox.SuggestBoxPopUpValue;
import org.jboss.hal.testsuite.fragment.shared.modal.suggestbox.SuggestedItemNotFoundException;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class SuggestBoxPopUp
extends PopUpFragment {
    private static final String TABLE_HTML_NAME = "table";

    public List<SuggestBoxPopUpValue> getValues() {
        By selector = By.cssSelector((String)"tr td");
        List elements = this.getTableWithSuggestedItems().findElements(selector);
        return elements.stream().map(SuggestBoxPopUpValue::new).collect(Collectors.toList());
    }

    public List<String> getLabelValues() {
        return this.getValues().stream().map(SuggestBoxPopUpValue::toString).collect(Collectors.toList());
    }

    public void selectSuggestionByLabel(Function<String, Boolean> comparator) {
        Optional<SuggestBoxPopUpValue> valueOptional = this.getValues().stream().filter(value -> (Boolean)comparator.apply(value.toString())).findFirst();
        if (!valueOptional.isPresent()) {
            throw new SuggestedItemNotFoundException("Suggestion not found by given comparator!");
        }
        valueOptional.get().select();
    }

    public void selectSuggestionByLabel(String label) {
        try {
            this.selectSuggestionByLabel(label::equals);
        }
        catch (SuggestedItemNotFoundException e) {
            throw new SuggestedItemNotFoundException("Suggestion identified by label '" + label + "' was not found!");
        }
    }

    private WebElement getSuggestBoxContent() {
        String className = PropUtils.get("components.suggestboxpopup.content.class");
        ByJQuery selector = ByJQuery.selector((String)("." + className));
        return this.root.findElement((By)selector);
    }

    private WebElement getTableWithSuggestedItems() {
        ByJQuery selector = ByJQuery.selector((String)TABLE_HTML_NAME);
        return this.getSuggestBoxContent().findElement((By)selector);
    }
}

