/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.rhaccess;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.rhaccess.RHAccessFragment;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class RHAccessOpenTicketFragment
extends RHAccessFragment {
    protected final By MY_ACCOUNT_BUTTON = ByJQuery.selector((String)"button:contains(My Account)");
    protected final String OWNER_SELECTION_ID = PropUtils.get("rhaccess.open.case.owner.id");
    protected final By OWNER_BUTTON_SELECTOR = ByJQuery.selector((String)("#" + this.OWNER_SELECTION_ID + " a"));
    protected final String SUMMARY_INPUT_ID = PropUtils.get("rhaccess.open.case.summary.id");
    protected final String DESCRIPTION_AREA_CLASS = PropUtils.get("rhaccess.open.case.description.class");

    public void setMyAccount() {
        this.waitLongUntilElementIs(this.MY_ACCOUNT_BUTTON, (SearchContext)this.root).enabled();
        this.root.findElement(this.MY_ACCOUNT_BUTTON).click();
    }

    public void setOwner(String ownerName) {
        this.waitLongUntilElementIs(this.OWNER_BUTTON_SELECTOR, (SearchContext)this.root).enabled();
        this.root.findElement(this.OWNER_BUTTON_SELECTOR).click();
    }

    public void setProduct(String productName) {
        this.setDropDownField(PropUtils.get("rhaccess.open.case.product.id"), productName);
    }

    public void setVersion(String version) {
        this.setDropDownField(PropUtils.get("rhaccess.open.case.product.version.id"), version);
    }

    protected void setDropDownField(String selectorId, String value) {
        ByJQuery statusSelector = ByJQuery.selector((String)("select[id=" + selectorId + "]"));
        this.waitLongUntilElementIs((By)statusSelector, (SearchContext)this.root).visible();
        WebElement selectElement = this.root.findElement((By)statusSelector);
        selectElement.click();
        Select statusSelect = new Select(selectElement);
        statusSelect.selectByVisibleText(value);
    }

    protected WebElement getField(String title) {
        return this.root.findElement((By)ByJQuery.selector((String)("div.rha-create-field:contains(" + title + ")")));
    }

    public void setSummary(String summary) {
        this.root.findElement(By.id((String)this.SUMMARY_INPUT_ID)).sendKeys(new CharSequence[]{summary});
    }

    public void setDescription(String description) {
        this.root.findElement((By)ByJQuery.selector((String)("textarea." + this.DESCRIPTION_AREA_CLASS))).sendKeys(new CharSequence[]{description});
    }

    public void next() {
        this.clickEnabledButton("Next");
    }

    public void submit() {
        this.clickEnabledButton("Submit");
    }

    protected void clickEnabledButton(String textLabel) {
        WebElement button = this.getButton(textLabel);
        Graphene.waitGui().until().element(button).is().enabled();
        button.click();
    }

    public void setGroup(String group) {
        WebElement fieldElement = this.getField("Case Group:");
        fieldElement.click();
        ByJQuery groupSelector = ByJQuery.selector((String)("li:contains(" + group + ")"));
        WebElement groupElement = fieldElement.findElement((By)groupSelector);
        groupElement.click();
    }
}

