/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.cli;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jboss.hal.testsuite.cli.CliClient;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.cli.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneManager
extends ServerManager {
    private static Logger log = LoggerFactory.getLogger(StandaloneManager.class);

    public StandaloneManager(CliClient cliClient) {
        super(cliClient);
    }

    @Override
    public boolean isInRunningState() {
        try {
            return this.cliClient.readAttribute(null, "server-state").equals("running");
        }
        catch (IllegalStateException ex) {
            log.info("Unable to connect via CLI => server is probably down");
            return false;
        }
    }

    public void restoreStandaloneConfig(File originalFile) throws IOException {
        if (originalFile == null) {
            throw new IllegalArgumentException("originalFile must not be null");
        }
        log.info("Restoring config file...");
        File fileCurrent = new File(this.cliClient.readAttribute("/core-service=server-environment", "config-file"));
        FileUtils.copyFile((File)originalFile, (File)fileCurrent);
        log.info("Config file {} restored with content of {}", (Object)fileCurrent.getAbsolutePath(), (Object)originalFile.getAbsolutePath());
    }

    public File backupStandaloneConfig(File backupFile) throws IOException {
        log.info("Backuping config file...");
        File fileOriginal = new File(this.cliClient.readAttribute("/core-service=server-environment", "config-file"));
        File fileBackup = backupFile;
        if (fileBackup == null) {
            fileBackup = File.createTempFile("config_", ".backup", new File(this.cliClient.readAttribute("/core-service=server-environment", "temp-dir")));
        }
        FileUtils.copyFile((File)fileOriginal, (File)fileBackup);
        log.info("Config file {} backuped to {}", (Object)fileOriginal.getAbsolutePath(), (Object)fileBackup.getAbsolutePath());
        return fileBackup;
    }

    @Override
    public boolean waitUntilAvailable() {
        return this.waitUntilAvailable(60000L);
    }

    @Override
    public boolean waitUntilAvailable(long timeout) {
        long timePassed = 0L;
        boolean isRunning = false;
        long waitTimeInterval = 500L;
        while (timePassed < timeout && !isRunning) {
            isRunning = this.isInRunningState();
            if (isRunning) continue;
            log.info("Waiting for additional {} ms for server to get in running state (already waited for {} ms out of {} ms)", new Object[]{waitTimeInterval, timePassed, timeout});
            Library.letsSleep(waitTimeInterval);
            timePassed += waitTimeInterval;
        }
        return isRunning;
    }
}

