/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.config.undertow;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.cli.Library;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class UndertowFragment
extends ConfigFragment {
    public Boolean isErrorShowedInForm() {
        ByJQuery selector = ByJQuery.selector((String)"div.form-item-error-desc:visible");
        return this.isElementVisible((By)selector);
    }

    public Boolean isElementVisible(By selector) {
        try {
            Graphene.waitAjax().until().element(selector).is().visible();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Boolean editTextAndSave(String identifier, String value) {
        Editor editor = this.edit();
        editor.text(identifier, value);
        return this.save();
    }

    public void editTextHumanly(Editor editor, String identifier, String value) {
        WebElement input = editor.getText(identifier);
        while (!input.isDisplayed()) {
            Console.withBrowser(this.browser).pageDown();
        }
        input.click();
        int length = input.getAttribute("value").length();
        input.click();
        for (int i = 0; i < length; ++i) {
            input.sendKeys(new CharSequence[]{Keys.DELETE});
            input.click();
            Library.letsSleep(100L);
        }
        Graphene.waitGui().until().element(input).value().equalTo("");
        input.click();
        for (char c : value.toCharArray()) {
            input.sendKeys(new CharSequence[]{Character.toString(c)});
            input.click();
            Library.letsSleep(100L);
        }
        input.click();
        Graphene.waitGui().until().element(input).value().equalTo(value);
    }

    @Override
    public Boolean editCheckboxAndSave(String identifier, Boolean value) {
        this.edit().checkbox(identifier, value);
        return this.save();
    }

    @Override
    public Boolean selectOptionAndSave(String identifier, String value) {
        this.edit().select(identifier, value);
        return this.save();
    }
}

