/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.MessageListEntry;
import org.jboss.hal.testsuite.fragment.MessageListEntryFragment;
import org.jboss.hal.testsuite.fragment.PopUpFragment;
import org.jboss.hal.testsuite.fragment.shared.modal.MessageWindow;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class MessagesListFragment
extends PopUpFragment {
    public static final String CLASS_MSG_DIV = PropUtils.get("messagelist.list.class");
    public static final String CLEAR_BUTTON_LABEL = PropUtils.get("messagelist.clear.label");

    public int getCount() {
        return this.getMessageElements().size();
    }

    public List<MessageListEntryFragment> getMessages() {
        ArrayList<MessageListEntryFragment> msgs = new ArrayList<MessageListEntryFragment>();
        for (WebElement table : this.getMessageElements()) {
            msgs.add((MessageListEntryFragment)Graphene.createPageFragment(MessageListEntryFragment.class, (WebElement)table));
        }
        return msgs;
    }

    public List<MessageListEntryFragment> getUnreadMessages() {
        ArrayList<MessageListEntryFragment> msgs = new ArrayList<MessageListEntryFragment>();
        for (MessageListEntryFragment m : this.getMessages()) {
            if (!m.isUnread()) continue;
            msgs.add(m);
        }
        return msgs;
    }

    public boolean hasMessages() {
        return !this.getMessageElements().isEmpty();
    }

    public boolean hasUnreadMessages() {
        return !this.getUnreadMessages().isEmpty();
    }

    public void clear() {
        this.clickLinkByLabel(CLEAR_BUTTON_LABEL);
    }

    public MessageWindow openMessage(int idx) {
        this.getMessageElements().get(idx).click();
        Console console = Console.withBrowser(this.browser);
        return console.openedWindow(MessageWindow.class);
    }

    private List<WebElement> getMessageElements() {
        return this.root.findElement(By.className((String)CLASS_MSG_DIV)).findElements((By)ByJQuery.selector((String)"div:first div table"));
    }

    public List<MessageListEntry> getMessagesAsData() {
        List<MessageListEntryFragment> msgs = this.getMessages();
        ArrayList<MessageListEntry> list = new ArrayList<MessageListEntry>();
        for (MessageListEntryFragment m : msgs) {
            list.add(new MessageListEntry(m));
        }
        return list;
    }
}

