/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.spi;

import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.NoGatekeeper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jboss.as.console.client.plugins.AccessControlMetaData;
import org.jboss.as.console.client.plugins.BootstrapOperation;
import org.jboss.as.console.client.plugins.RuntimeExtensionMetaData;
import org.jboss.as.console.client.plugins.SearchIndexMetaData;
import org.jboss.as.console.client.plugins.SubsystemExtensionMetaData;
import org.jboss.as.console.spi.AccessControl;
import org.jboss.as.console.spi.BeanFactoryExtension;
import org.jboss.as.console.spi.ExtensionDeclaration;
import org.jboss.as.console.spi.GinExtension;
import org.jboss.as.console.spi.GinExtensionBinding;
import org.jboss.as.console.spi.ModuleConfig;
import org.jboss.as.console.spi.OperationMode;
import org.jboss.as.console.spi.RuntimeExtension;
import org.jboss.as.console.spi.SearchIndex;
import org.jboss.as.console.spi.SubsystemExtension;
import org.jboss.as.console.spi.TemplateProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class SPIProcessor
extends AbstractProcessor {
    private static final String EXTENSION_TEMPLATE = "Extension.tmpl";
    private static final String EXTENSION_FILENAME = "org.jboss.as.console.client.core.gin.Composite";
    private static final String BINDING_TEMPLATE = "ExtensionBinding.tmpl";
    private static final String BINDING_FILENAME = "org.jboss.as.console.client.core.gin.CompositeBinding";
    private static final String BEAN_FACTORY_TEMPLATE = "BeanFactory.tmpl";
    private static final String BEAN_FACTORY_FILENAME = "org.jboss.as.console.client.shared.BeanFactory";
    private static final String SUBSYSTEM_FILENAME = "org.jboss.as.console.client.plugins.SubsystemRegistryImpl";
    private static final String SUBSYSTEM_TEMPLATE = "SubsystemExtensions.tmpl";
    private static final String ACCESS_FILENAME = "org.jboss.as.console.client.plugins.AccessControlRegistryImpl";
    private static final String ACCESS_TEMPLATE = "AccessControlRegistry.tmpl";
    private static final String SEARCH_INDEX_FILENAME = "org.jboss.as.console.client.plugins.SearchIndexRegistryImpl";
    private static final String SEARCH_INDEX_TEMPLATE = "SearchIndexRegistry.tmpl";
    private static final String RUNTIME_FILENAME = "org.jboss.as.console.client.plugins.RuntimeLHSItemExtensionRegistryImpl";
    private static final String RUNTIME_TEMPLATE = "RuntimeExtensions.tmpl";
    private static final String VERSION_INFO_FILENAME = "org.jboss.as.console.client.VersionInfo";
    private static final String VERSION_INFO_TEMPLATE = "VersionInfo.tmpl";
    private Filer filer;
    private ProcessingEnvironment processingEnv;
    private List<String> discoveredExtensions;
    private List<ExtensionDeclaration> discoveredBindings;
    private List<String> discoveredBeanFactories;
    private List<String> categoryClasses;
    private List<SubsystemExtensionMetaData> subsystemDeclararions;
    private List<AccessControlMetaData> accessControlDeclararions;
    private List<SearchIndexMetaData> searchIndexDeclarations;
    private List<BootstrapOperation> bootstrapOperations;
    private List<RuntimeExtensionMetaData> runtimeExtensions;
    private Set<String> modules = new LinkedHashSet<String>();
    private Set<String> nameTokens;
    private List<ModuleConfig> moduleConfigs;
    private Map<String, String> gwtConfigProps;

    @Override
    public void init(ProcessingEnvironment env) {
        this.processingEnv = env;
        this.filer = env.getFiler();
        this.discoveredExtensions = new ArrayList<String>();
        this.discoveredBindings = new ArrayList<ExtensionDeclaration>();
        this.discoveredBeanFactories = new ArrayList<String>();
        this.categoryClasses = new ArrayList<String>();
        this.subsystemDeclararions = new ArrayList<SubsystemExtensionMetaData>();
        this.accessControlDeclararions = new ArrayList<AccessControlMetaData>();
        this.searchIndexDeclarations = new ArrayList<SearchIndexMetaData>();
        this.bootstrapOperations = new ArrayList<BootstrapOperation>();
        this.runtimeExtensions = new ArrayList<RuntimeExtensionMetaData>();
        this.nameTokens = new HashSet<String>();
        this.moduleConfigs = new ArrayList<ModuleConfig>();
        this.moduleConfigs.add(new ModuleConfig(this.filer, "App_base.gwt.xml.tmpl", "App.gwt.xml"));
        this.moduleConfigs.add(new ModuleConfig(this.filer, "App_WF.gwt.xml.tmpl", "App_WF.gwt.xml"));
        this.moduleConfigs.add(new ModuleConfig(this.filer, "App_WF_full.gwt.xml.tmpl", "App_WF_full.gwt.xml"));
        this.moduleConfigs.add(new ModuleConfig(this.filer, "App_WF_dev.gwt.xml.tmpl", "App_WF_dev.gwt.xml"));
        this.moduleConfigs.add(new ModuleConfig(this.filer, "App_RH.gwt.xml.tmpl", "App_RH.gwt.xml"));
        this.moduleConfigs.add(new ModuleConfig(this.filer, "App_RH_dev.gwt.xml.tmpl", "App_RH_dev.gwt.xml"));
        env.getMessager();
        this.parseGwtProperties();
    }

    private void parseGwtProperties() {
        Map<String, String> options = this.processingEnv.getOptions();
        this.gwtConfigProps = new HashMap<String, String>();
        for (String key : options.keySet()) {
            if (!key.startsWith("gwt.")) continue;
            this.gwtConfigProps.put(key.substring(4, key.length()), options.get(key));
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(GinExtension.class.getName());
        types.add(GinExtensionBinding.class.getName());
        types.add(BeanFactoryExtension.class.getName());
        types.add(SubsystemExtension.class.getName());
        types.add(RuntimeExtension.class.getName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            System.out.println("=================================");
            System.out.println("Begin Components discovery ...");
            System.out.println("=================================");
            Set<? extends Element> extensionElements = roundEnv.getElementsAnnotatedWith(GinExtension.class);
            for (Element element : extensionElements) {
                this.handleGinExtensionElement(element);
            }
            System.out.println("=================================");
            System.out.println("Begin Bindings discovery ...");
            System.out.println("=================================");
            Set<? extends Element> extensionBindingElements = roundEnv.getElementsAnnotatedWith(GinExtensionBinding.class);
            for (Element element : extensionBindingElements) {
                this.handleGinExtensionBindingElement(element);
            }
            System.out.println("=================================");
            System.out.println("Begin BeanFactory discovery ...");
            System.out.println("=================================");
            Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(BeanFactoryExtension.class);
            for (Element element : set) {
                this.handleBeanFactoryElement(element);
            }
            System.out.println("=================================");
            System.out.println("Begin Subsystem discovery ...");
            System.out.println("=================================");
            Set<? extends Element> set2 = roundEnv.getElementsAnnotatedWith(SubsystemExtension.class);
            for (Element element : set2) {
                this.handleSubsystemElement(element);
            }
            System.out.println("=================================");
            System.out.println("Parse AccessControl metadata ...");
            System.out.println("=================================");
            Set<? extends Element> set3 = roundEnv.getElementsAnnotatedWith(NameToken.class);
            for (Element element : set3) {
                this.handleAccessControlElement(element);
            }
            System.out.println("=================================");
            System.out.println("Parse SearchIndex metadata ...");
            System.out.println("=================================");
            Set<? extends Element> set4 = roundEnv.getElementsAnnotatedWith(NameToken.class);
            for (Element element : set4) {
                this.handleSearchIndexElement(element);
            }
            System.out.println("=================================");
            System.out.println("Begin Runtime Extension discovery ...");
            System.out.println("=================================");
            Set<? extends Element> set5 = roundEnv.getElementsAnnotatedWith(RuntimeExtension.class);
            for (Element element : set5) {
                this.handleRuntimeExtensions(element);
            }
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeFiles();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to process SPI artifacts");
            }
            System.out.println("=================================");
            System.out.println("SPI component discovery completed.");
        }
        return true;
    }

    private void handleAccessControlElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(NameToken.class.getName())) continue;
            NameToken nameToken = element.getAnnotation(NameToken.class);
            AccessControl accessControl = element.getAnnotation(AccessControl.class);
            if (accessControl != null) {
                for (String resourceAddress : accessControl.resources()) {
                    AccessControlMetaData declared = new AccessControlMetaData(nameToken.value()[0], resourceAddress);
                    declared.setRecursive(accessControl.recursive());
                    this.accessControlDeclararions.add(declared);
                }
                for (String opString : accessControl.operations()) {
                    if (!opString.contains("#")) {
                        throw new IllegalArgumentException("Invalid operation string:" + opString);
                    }
                    BootstrapOperation op = new BootstrapOperation(nameToken.value()[0], opString);
                    this.bootstrapOperations.add(op);
                }
                continue;
            }
            if (element.getAnnotation(NoGatekeeper.class) != null) continue;
            Name simpleName = element.getEnclosingElement() != null ? element.getEnclosingElement().getSimpleName() : element.getSimpleName();
            System.out.println(simpleName + "(#" + nameToken.value()[0] + ")" + " is missing @AccessControl annotation!");
        }
    }

    private void handleSearchIndexElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(NameToken.class.getName())) continue;
            NameToken nameToken = element.getAnnotation(NameToken.class);
            AccessControl accessControl = element.getAnnotation(AccessControl.class);
            SearchIndex searchIndex = element.getAnnotation(SearchIndex.class);
            OperationMode operationMode = element.getAnnotation(OperationMode.class);
            if (accessControl == null) continue;
            boolean standalone = true;
            boolean domain = true;
            String[] keywords = null;
            boolean include = true;
            if (searchIndex != null) {
                keywords = searchIndex.keywords();
                boolean bl = include = !searchIndex.exclude();
            }
            if (operationMode != null) {
                standalone = operationMode.value() == OperationMode.Mode.STANDALONE;
                boolean bl = domain = operationMode.value() == OperationMode.Mode.DOMAIN;
            }
            if (!include) continue;
            SearchIndexMetaData searchIndexMetaData = new SearchIndexMetaData(nameToken.value()[0], standalone, domain, accessControl.resources(), keywords);
            this.searchIndexDeclarations.add(searchIndexMetaData);
        }
    }

    private void handleGinExtensionBindingElement(Element element) {
        String typeName = element.asType().toString();
        System.out.println("Binding: " + typeName);
        this.discoveredBindings.add(new ExtensionDeclaration(typeName));
    }

    private void handleRuntimeExtensions(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(RuntimeExtension.class.getName())) continue;
            NameToken nameToken = element.getAnnotation(NameToken.class);
            RuntimeExtension extension = element.getAnnotation(RuntimeExtension.class);
            if (nameToken == null) continue;
            System.out.println("Runtime Extension: " + extension.name() + " -> " + nameToken.value()[0]);
            RuntimeExtensionMetaData declared = new RuntimeExtensionMetaData(extension.name(), nameToken.value()[0], extension.group(), extension.key());
            this.runtimeExtensions.add(declared);
        }
    }

    private void handleGinExtensionElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(GinExtension.class.getName())) continue;
            GinExtension comps = element.getAnnotation(GinExtension.class);
            String module = comps.value();
            if (module != null && module.length() > 0) {
                this.modules.add(module);
            }
            PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
            String fqn = packageElement.getQualifiedName().toString() + "." + element.getSimpleName().toString();
            System.out.println("Components: " + fqn);
            this.discoveredExtensions.add(fqn);
        }
    }

    private void handleBeanFactoryElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Collection<? extends AnnotationValue> values;
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (annotationType.equals(BeanFactoryExtension.class.getName())) {
                PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
                String fqn = packageElement.getQualifiedName().toString() + "." + element.getSimpleName().toString();
                System.out.println("Factory: " + fqn);
                this.discoveredBeanFactories.add(fqn);
                continue;
            }
            if (!annotationType.equals("com.google.web.bindery.autobean.shared.AutoBeanFactory.Category") || (values = annotationMirror.getElementValues().values()).size() <= 0) continue;
            for (AnnotationValue categoryClass : (List)values.iterator().next().getValue()) {
                this.categoryClasses.add(categoryClass.getValue().toString());
            }
        }
    }

    private void handleSubsystemElement(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.equals(SubsystemExtension.class.getName())) continue;
            NameToken nameToken = element.getAnnotation(NameToken.class);
            SubsystemExtension subsystem = element.getAnnotation(SubsystemExtension.class);
            if (nameToken == null) continue;
            System.out.println("Subsystem: " + subsystem.name() + " -> " + nameToken.value()[0]);
            SubsystemExtensionMetaData declared = new SubsystemExtensionMetaData(subsystem.name(), nameToken.value()[0], subsystem.group(), subsystem.key());
            this.subsystemDeclararions.add(declared);
            if (this.nameTokens.add(nameToken.value()[0])) continue;
            throw new RuntimeException("Duplicate name token '" + nameToken.value()[0] + "' declared on '" + element.asType());
        }
    }

    private void writeFiles() throws Exception {
        this.writeGinjectorFile();
        this.writeBindingFile();
        this.writeBeanFactoryFile();
        this.writeSubsystemFile();
        this.writeAccessControlFile();
        this.writeSearchIndexFile();
        this.writeRuntimeFile();
        this.writeProxyConfigurations();
        this.writeVersionInfo();
        for (ModuleConfig moduleConfig : this.moduleConfigs) {
            moduleConfig.writeModuleFile(this.modules, this.gwtConfigProps);
        }
    }

    private void writeAccessControlFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("metaData", this.accessControlDeclararions);
        model.put("operations", this.bootstrapOperations);
        JavaFileObject sourceFile = this.filer.createSourceFile(ACCESS_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(ACCESS_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeSearchIndexFile() throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("metaData", this.searchIndexDeclarations);
        JavaFileObject sourceFile = this.filer.createSourceFile(SEARCH_INDEX_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(SEARCH_INDEX_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeGinjectorFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensions", this.discoveredExtensions);
        JavaFileObject sourceFile = this.filer.createSourceFile(EXTENSION_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(EXTENSION_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeBindingFile() throws Exception {
        JavaFileObject sourceFile = this.filer.createSourceFile(BINDING_FILENAME, new Element[0]);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensions", this.discoveredBindings);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(BINDING_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeBeanFactoryFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensions", this.discoveredBeanFactories);
        model.put("categoryClasses", this.categoryClasses);
        JavaFileObject sourceFile = this.filer.createSourceFile(BEAN_FACTORY_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(BEAN_FACTORY_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeSubsystemFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subsystemExtensions", this.subsystemDeclararions);
        JavaFileObject sourceFile = this.filer.createSourceFile(SUBSYSTEM_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(SUBSYSTEM_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeRuntimeFile() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("runtimeMenuItemExtensions", this.runtimeExtensions);
        JavaFileObject sourceFile = this.filer.createSourceFile(RUNTIME_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(RUNTIME_TEMPLATE, model, output);
        output.flush();
        output.close();
    }

    private void writeProxyConfigurations() {
        try {
            String devHost = this.gwtConfigProps.get("console.dev.host") != null ? this.gwtConfigProps.get("console.dev.host") : "127.0.0.1";
            String devPort = this.gwtConfigProps.get("console.dev.port") != null ? this.gwtConfigProps.get("console.dev.port") : "9990";
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("devHost", devHost);
            model.put("devPort", devPort);
            FileObject sourceFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "gwt-proxy.properties", new Element[0]);
            OutputStream output1 = sourceFile.openOutputStream();
            FileObject sourceFile2 = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "upload-proxy.properties", new Element[0]);
            OutputStream output2 = sourceFile2.openOutputStream();
            FileObject sourceFile3 = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "patch-proxy.properties", new Element[0]);
            OutputStream output3 = sourceFile3.openOutputStream();
            FileObject sourceFile4 = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "logout.properties", new Element[0]);
            OutputStream output4 = sourceFile4.openOutputStream();
            new TemplateProcessor().process("gwt.proxy.tmpl", model, output1);
            new TemplateProcessor().process("gwt.proxy.upload.tmpl", model, output2);
            new TemplateProcessor().process("gwt.proxy.patch.tmpl", model, output3);
            new TemplateProcessor().process("gwt.proxy.logout.tmpl", model, output4);
            output1.close();
            output2.close();
            output3.close();
            output4.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file", e);
        }
    }

    private void writeVersionInfo() throws IOException {
        Map<String, String> options = this.processingEnv.getOptions();
        String version = options.containsKey("version") ? options.get("version") : "n/a";
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("version", version);
        JavaFileObject sourceFile = this.filer.createSourceFile(VERSION_INFO_FILENAME, new Element[0]);
        OutputStream output = sourceFile.openOutputStream();
        new TemplateProcessor().process(VERSION_INFO_TEMPLATE, model, output);
        output.flush();
        output.close();
    }
}

