/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.servlet.ServletProtocolConfiguration;
import org.jboss.arquillian.protocol.servlet.ServletURIHandler;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMethodExecutor
implements ContainerMethodExecutor {
    public static final String ARQUILLIAN_SERVLET_NAME = "ArquillianServletRunner";
    public static final String ARQUILLIAN_SERVLET_MAPPING = "/ArquillianServletRunner";
    private static final Logger log = Logger.getLogger(ContainerMethodExecutor.class.getName());
    protected ServletURIHandler uriHandler;
    protected CommandCallback callback;
    protected ServletProtocolConfiguration config;

    protected ServletMethodExecutor() {
    }

    public ServletMethodExecutor(ServletProtocolConfiguration config, Collection<HTTPContext> contexts, CommandCallback callback) {
        if (config == null) {
            throw new IllegalArgumentException("ServletProtocolConfiguration must be specified");
        }
        if (contexts == null || contexts.size() == 0) {
            throw new IllegalArgumentException("HTTPContext must be specified");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback must be specified");
        }
        this.config = config;
        this.uriHandler = new ServletURIHandler(config, contexts);
        this.callback = callback;
    }

    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor must be specified");
        }
        URI targetBaseURI = this.uriHandler.locateTestServlet(testMethodExecutor.getMethod());
        Class<?> testClass = testMethodExecutor.getInstance().getClass();
        String url = targetBaseURI.toASCIIString() + ARQUILLIAN_SERVLET_MAPPING + "?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + testMethodExecutor.getMethod().getName();
        String eventUrl = targetBaseURI.toASCIIString() + ARQUILLIAN_SERVLET_MAPPING + "?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + testMethodExecutor.getMethod().getName() + "&cmd=event";
        Timer eventTimer = null;
        try {
            eventTimer = this.createCommandServicePullTimer(eventUrl);
            TestResult testResult = this.executeWithRetry(url, TestResult.class);
            return testResult;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error launching test " + testClass.getName() + " " + testMethodExecutor.getMethod(), e);
        }
        finally {
            if (eventTimer != null) {
                eventTimer.cancel();
            }
        }
    }

    protected <T> T executeWithRetry(String url, Class<T> type) throws Exception {
        long timeoutTime = System.currentTimeMillis() + 1000L;
        boolean interrupted = false;
        while (timeoutTime > System.currentTimeMillis()) {
            T o = this.execute(url, type, null);
            if (o != null) {
                return o;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        throw new IllegalStateException("Error launching request at " + url + ". No result returned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(String url, Class<T> returnType, Object requestObject) throws Exception {
        URLConnection connection = new URL(url).openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalStateException("Not an http connection! " + connection);
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setUseCaches(false);
        httpConnection.setDefaultUseCaches(false);
        httpConnection.setDoInput(true);
        this.prepareHttpConnection(httpConnection);
        try {
            if (requestObject != null) {
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(true);
                httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
            }
            if (requestObject != null) {
                ObjectOutputStream ous = new ObjectOutputStream(httpConnection.getOutputStream());
                try {
                    ous.writeObject(requestObject);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error sending request Object, " + requestObject, e2);
                }
                finally {
                    ous.flush();
                    ous.close();
                }
            }
            try {
                httpConnection.getResponseCode();
            }
            catch (ConnectException e) {
                T e2 = null;
                httpConnection.disconnect();
                return e2;
            }
            if (httpConnection.getResponseCode() == 200) {
                Object o;
                ObjectInputStream ois = new ObjectInputStream(httpConnection.getInputStream());
                try {
                    o = ois.readObject();
                }
                finally {
                    ois.close();
                }
                if (!returnType.isInstance(o)) {
                    throw new IllegalStateException("Error reading results, expected a " + returnType.getName() + " but got " + o);
                }
                T t = returnType.cast(o);
                return t;
            }
            if (httpConnection.getResponseCode() == 204) {
                T t = null;
                return t;
            }
            if (httpConnection.getResponseCode() != 404) {
                throw new IllegalStateException("Error launching test at " + url + ". Got " + httpConnection.getResponseCode() + " (" + httpConnection.getResponseMessage() + ")");
            }
        }
        finally {
            httpConnection.disconnect();
        }
        return null;
    }

    protected void prepareHttpConnection(HttpURLConnection connection) {
    }

    protected Timer createCommandServicePullTimer(final String eventUrl) {
        if (this.config.getPullInMilliSeconds() == null || this.config.getPullInMilliSeconds() <= 0) {
            log.warning("The Servlet Protocol has been configured with a pullInMilliSeconds interval of " + this.config.getPullInMilliSeconds() + ". The effect of this is that the Command Service has been disabled. Depending on which features you use, this might cause serious delays. Be on high alert for  possible timeout runtime exceptions.");
            return null;
        }
        Timer eventTimer = new Timer();
        eventTimer.schedule(new TimerTask(){

            public void run() {
                block3: {
                    try {
                        Object o = ServletMethodExecutor.this.execute(eventUrl, Object.class, null);
                        if (o == null) break block3;
                        if (o instanceof Command) {
                            Command command = (Command)o;
                            ServletMethodExecutor.this.callback.fired(command);
                            ServletMethodExecutor.this.execute(eventUrl, Object.class, command);
                            break block3;
                        }
                        throw new RuntimeException("Recived a non " + Command.class.getName() + " object on event channel");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 0L, (long)this.config.getPullInMilliSeconds().intValue());
        return eventTimer;
    }
}

