/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;
import org.jboss.arquillian.osgi.OSGiContainer;
import org.jboss.arquillian.osgi.RepositoryArchiveLocator;
import org.jboss.arquillian.osgi.SecurityActions;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandler;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

class OSGiContainerImpl
implements OSGiContainer {
    private BundleContext context;
    private TestClass testClass;
    private ResourceCallbackHandler callbackHandler;

    OSGiContainerImpl(BundleContext context, TestClass testClass, ResourceCallbackHandler callbackHandler) {
        this.context = context;
        this.testClass = testClass;
        this.callbackHandler = callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle installBundle(Archive<?> archive) throws BundleException {
        ByteArrayInputStream inputStream;
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.exportZip((OutputStream)baos);
            inputStream = new ByteArrayInputStream(baos.toByteArray());
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
        return this.context.installBundle(archive.getName(), (InputStream)inputStream);
    }

    @Override
    public Bundle installBundle(String artifactId) throws BundleException {
        return this.installBundle(null, artifactId, null);
    }

    @Override
    public Bundle installBundle(String groupId, String artifactId, String version) throws BundleException {
        URL artifactURL = RepositoryArchiveLocator.getArtifactURL(groupId, artifactId, version);
        if (artifactURL == null) {
            return null;
        }
        BundleInfo info = BundleInfo.createBundleInfo((URL)artifactURL);
        Bundle bundle = this.getBundle(info.getSymbolicName(), info.getVersion());
        if (bundle != null) {
            return bundle;
        }
        bundle = this.context.installBundle(artifactURL.toExternalForm());
        return bundle;
    }

    @Override
    public Bundle getBundle(String symbolicName, Version version) throws BundleException {
        if (this.context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (symbolicName == null) {
            throw new IllegalArgumentException("Null symbolicName");
        }
        for (Bundle bundle : this.context.getBundles()) {
            boolean versionMatch;
            boolean artefactMatch = symbolicName.equals(bundle.getSymbolicName());
            boolean bl = versionMatch = version == null || version.equals((Object)bundle.getVersion());
            if (!artefactMatch || !versionMatch) continue;
            return bundle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Archive<?> getTestArchive(String name) {
        InputStream input = this.getTestArchiveStream(name);
        ClassLoader ctxLoader = SecurityActions.getThreadContextClassLoader();
        try {
            SecurityActions.setThreadContextClassLoader(ArchiveBase.class.getClassLoader());
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)name);
            ZipImporter zipImporter = (ZipImporter)archive.as(ZipImporter.class);
            zipImporter.importZip(new ZipInputStream(input));
            JavaArchive javaArchive = archive;
            return javaArchive;
        }
        finally {
            SecurityActions.setThreadContextClassLoader(ctxLoader);
        }
    }

    @Override
    public InputStream getTestArchiveStream(String name) {
        try {
            byte[] bytes = this.callbackHandler.requestResource(this.testClass, name);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return bais;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain test archive: " + name, ex);
        }
    }
}

