/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.internal;

import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.osgi.internal.AbstractOSGiContainer;
import org.jboss.arquillian.spi.Logger;
import org.jboss.arquillian.spi.TestClass;
import org.osgi.framework.BundleContext;

public class RemoteOSGiContainer
extends AbstractOSGiContainer {
    private static final Logger log = Logger.getLogger(RemoteOSGiContainer.class);
    private JMXConnector jmxConnector;

    public RemoteOSGiContainer(BundleContext context, TestClass testClass) {
        super(context, testClass);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        String rmiHost = this.getFrameworkProperty("org.jboss.osgi.rmi.host", "127.0.0.1");
        Integer rmiPort = Integer.parseInt(this.getFrameworkProperty("org.jboss.osgi.rmi.port", "1090")) + 100;
        String urlString = System.getProperty("arq.callback.url", "service:jmx:rmi:///jndi/rmi://" + rmiHost + ":" + rmiPort + "/jmxrmi");
        log.fine("Connecting JMXConnector to: " + urlString);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(urlString);
            this.jmxConnector = JMXConnectorFactory.connect(serviceURL, env);
            return this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection", ex);
        }
    }

    private String getFrameworkProperty(String key, String defaultValue) {
        String value = this.getBundleContext().getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

