/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.arquillian.osgi.OSGiContainer;
import org.jboss.arquillian.osgi.RepositoryArchiveLocator;
import org.jboss.arquillian.osgi.internal.InternalArchiveProvider;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.util.TCCLActions;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public abstract class AbstractOSGiContainer
implements OSGiContainer {
    private BundleContext context;
    private TestClass testClass;

    protected AbstractOSGiContainer(BundleContext context, TestClass testClass) {
        this.context = context;
        this.testClass = testClass;
    }

    public static ObjectName getArchiveProviderName(TestClass testClass) {
        String name = "jboss.arquillian:archive-provider=" + testClass.getSimpleName();
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name: " + name);
        }
    }

    protected BundleContext getBundleContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle installBundle(Archive<?> archive) throws BundleException {
        ByteArrayInputStream inputStream;
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.exportZip((OutputStream)baos);
            inputStream = new ByteArrayInputStream(baos.toByteArray());
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
        return this.context.installBundle(archive.getName(), (InputStream)inputStream);
    }

    @Override
    public Bundle installBundle(String artifactId) throws BundleException {
        return this.installBundle(null, artifactId, null);
    }

    @Override
    public Bundle installBundle(String groupId, String artifactId, String version) throws BundleException {
        URL artifactURL = RepositoryArchiveLocator.getArtifactURL(groupId, artifactId, version);
        if (artifactURL == null) {
            return null;
        }
        BundleInfo info = BundleInfo.createBundleInfo((URL)artifactURL);
        Bundle bundle = this.getBundle(info.getSymbolicName(), info.getVersion());
        if (bundle != null) {
            return bundle;
        }
        bundle = this.context.installBundle(artifactURL.toExternalForm());
        return bundle;
    }

    @Override
    public Bundle getBundle(String symbolicName, Version version) throws BundleException {
        if (this.context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (symbolicName == null) {
            throw new IllegalArgumentException("Null symbolicName");
        }
        for (Bundle bundle : this.context.getBundles()) {
            boolean versionMatch;
            boolean artefactMatch = symbolicName.equals(bundle.getSymbolicName());
            boolean bl = versionMatch = version == null || version.equals((Object)bundle.getVersion());
            if (!artefactMatch || !versionMatch) continue;
            return bundle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Archive<?> getTestArchive(String name) {
        InputStream input = this.getTestArchiveStream(name);
        ClassLoader ctxLoader = TCCLActions.getClassLoader();
        try {
            TCCLActions.setClassLoader((ClassLoader)AbstractOSGiContainer.class.getClassLoader());
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)name);
            ZipImporter zipImporter = (ZipImporter)archive.as(ZipImporter.class);
            zipImporter.importZip(new ZipInputStream(input));
            JavaArchive javaArchive = archive;
            return javaArchive;
        }
        finally {
            TCCLActions.setClassLoader((ClassLoader)ctxLoader);
        }
    }

    @Override
    public InputStream getTestArchiveStream(String name) {
        try {
            MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
            ObjectName providerName = AbstractOSGiContainer.getArchiveProviderName(this.testClass);
            if (!mbeanServer.isRegistered(providerName)) {
                throw new IllegalStateException("ArchiveProvider not registered: " + providerName);
            }
            InternalArchiveProvider proxy = this.getMBeanProxy(mbeanServer, providerName, InternalArchiveProvider.class);
            return new ByteArrayInputStream(proxy.getTestArchive(name));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain test archive: " + name, ex);
        }
    }

    public abstract MBeanServerConnection getMBeanServerConnection();

    private <T> T getMBeanProxy(MBeanServerConnection mbeanServer, ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, name, interf, false);
    }
}

