/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.packager.osgi;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.arquillian.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        Archive bundleArchive = testDeployment.getApplicationArchive();
        if (JavaArchive.class.isInstance(bundleArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(bundleArchive), testDeployment.getAuxiliaryArchives());
        }
        throw new IllegalArgumentException(OSGiDeploymentPackager.class.getName() + " can not handle archive of type " + bundleArchive.getClass().getName());
    }

    private Archive<?> handleArchive(JavaArchive archive, Collection<Archive<?>> auxiliaryArchives) {
        try {
            this.validateBundleArchive((Archive<?>)archive);
            return archive;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid OSGi bundle: " + archive, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateBundleArchive(Archive<?> archive) throws Exception {
        String archiveName = archive.getName();
        int dotIndex = archiveName.lastIndexOf(".");
        if (dotIndex > 0) {
            archiveName = archiveName.substring(0, dotIndex);
        }
        File target = File.createTempFile(archiveName + "-", ".jar");
        try {
            ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
            exporter.exportZip(target, true);
            VirtualFile virtualFile = AbstractVFS.getRoot((URL)target.toURI().toURL());
            BundleInfo.createBundleInfo((VirtualFile)virtualFile);
        }
        finally {
            target.delete();
        }
    }
}

