/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit.container;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTestRunner
implements TestRunner {
    protected List<RunListener> getRunListeners() {
        return Collections.emptyList();
    }

    public TestResult execute(Class<?> testClass, String methodName) {
        JUnitCore runner = new JUnitCore();
        ExpectedExceptionHolder exceptionHolder = new ExpectedExceptionHolder();
        runner.addListener((RunListener)exceptionHolder);
        for (RunListener listener : this.getRunListeners()) {
            runner.addListener(listener);
        }
        Result result = runner.run(Request.method(testClass, (String)methodName));
        return this.convertToTestResult(result, exceptionHolder.getException());
    }

    private TestResult convertToTestResult(Result result, Throwable expectedException) {
        TestResult.Status status = TestResult.Status.PASSED;
        Throwable throwable = expectedException;
        if (result.getFailureCount() > 0) {
            status = TestResult.Status.FAILED;
            throwable = ((Failure)result.getFailures().get(0)).getException();
        }
        if (result.getIgnoreCount() > 0) {
            status = TestResult.Status.SKIPPED;
        }
        return new TestResult(status, throwable);
    }

    private class ExpectedExceptionHolder
    extends RunListener {
        private Throwable exception;

        private ExpectedExceptionHolder() {
        }

        public Throwable getException() {
            return this.exception;
        }

        public void testFinished(Description description) throws Exception {
            Test test = (Test)description.getAnnotation(Test.class);
            if (test != null && test.expected() != Test.None.class) {
                this.exception = (Throwable)Arquillian.caughtTestException.get();
                Arquillian.caughtTestException.set(null);
            }
        }
    }
}

