/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static Class<?> newInstance(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Unable to instantiate class with null class name string.");
        }
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

