/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.context.BrowserActions;
import org.jboss.arquillian.graphene.context.BrowserLocal;
import org.jboss.arquillian.graphene.context.ExtendedGrapheneContext;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.SearchContextInterceptor;
import org.jboss.arquillian.graphene.enricher.StaleElementInterceptor;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistryImpl;
import org.jboss.arquillian.graphene.page.extension.RemotePageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class GrapheneContextImpl
extends ExtendedGrapheneContext {
    private final GrapheneConfiguration configuration;
    private final WebDriver webDriver;
    private final Class<?> qualifier;
    private static final BrowserLocal<GrapheneContext> CURRENT_CONTEXT = new BrowserLocal();
    private static ThreadLocal<Map<Class<?>, GrapheneContext>> ALL_CONTEXTS = new ThreadLocal<Map<Class<?>, GrapheneContext>>(){

        @Override
        protected Map<Class<?>, GrapheneContext> initialValue() {
            return new HashMap();
        }
    };
    private static ThreadLocal<Map<Class<?>, LazyContext>> LAZY_CONTEXTS = new ThreadLocal<Map<Class<?>, LazyContext>>(){

        @Override
        protected Map<Class<?>, LazyContext> initialValue() {
            return new HashMap();
        }
    };

    private GrapheneContextImpl(GrapheneConfiguration configuration, WebDriver webDriver, Class<?> qualifier) {
        this.configuration = configuration;
        this.webDriver = webDriver;
        this.qualifier = qualifier;
    }

    public BrowserActions getBrowserActions() {
        return null;
    }

    public GrapheneConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PageExtensionInstallatorProvider getPageExtensionInstallatorProvider() {
        return null;
    }

    @Override
    public PageExtensionRegistry getPageExtensionRegistry() {
        return null;
    }

    public WebDriver getWebDriver(Class<?> ... interfaces) {
        return this.webDriver;
    }

    public Class<?> getQualifier() {
        return this.qualifier;
    }

    private static class LazyContext
    extends GrapheneContextImpl {
        private final Class<?> qualifier;
        private final PageExtensionRegistry registry;
        private final BrowserActions browserActions;
        private PageExtensionInstallatorProvider installatorProvider;
        private GrapheneProxyHandler handler;

        LazyContext(Class<?> qualifier, BrowserActions browserActions) {
            super(null, null, null);
            this.qualifier = qualifier;
            this.browserActions = browserActions;
            this.registry = new PageExtensionRegistryImpl();
        }

        @Override
        public BrowserActions getBrowserActions() {
            LazyContext context = (LazyContext)((Object)((Map)LAZY_CONTEXTS.get()).get(this.getQualifier()));
            if (context == null) {
                return this.browserActions;
            }
            return context.browserActions;
        }

        @Override
        public GrapheneConfiguration getConfiguration() {
            return this.getContext(true).getConfiguration();
        }

        @Override
        public PageExtensionInstallatorProvider getPageExtensionInstallatorProvider() {
            LazyContext context = (LazyContext)((Object)((Map)LAZY_CONTEXTS.get()).get(this.getQualifier()));
            if (context == null) {
                return this.installatorProvider;
            }
            return context.installatorProvider;
        }

        @Override
        public PageExtensionRegistry getPageExtensionRegistry() {
            LazyContext context = (LazyContext)((Object)((Map)LAZY_CONTEXTS.get()).get(this.getQualifier()));
            if (context == null) {
                return this.registry;
            }
            return context.registry;
        }

        @Override
        public Class<?> getQualifier() {
            if (Default.class.equals(this.qualifier)) {
                GrapheneContext context = this.getContext(false);
                if (context == null) {
                    return this.qualifier;
                }
                if (context instanceof LazyContext) {
                    return ((LazyContext)context).qualifier;
                }
                return context.getQualifier();
            }
            return this.qualifier;
        }

        @Override
        public WebDriver getWebDriver(Class<?> ... interfaces) {
            GrapheneContext context = this.getContext(false);
            if (context == null) {
                return (WebDriver)GrapheneProxy.getProxyForHandler(this.handler, WebDriver.class, interfaces);
            }
            if (GrapheneProxyUtil.isProxy(context.getWebDriver(new Class[0]))) {
                Class<?> superclass = context.getWebDriver(new Class[0]).getClass().getSuperclass();
                if (superclass != null && !GrapheneProxyUtil.isProxy(superclass) && WebDriver.class.isAssignableFrom(superclass)) {
                    return (WebDriver)GrapheneProxy.getProxyForHandler(this.handler, context.getWebDriver(new Class[0]).getClass().getSuperclass(), interfaces);
                }
                return (WebDriver)GrapheneProxy.getProxyForHandler(this.handler, WebDriver.class, interfaces);
            }
            return (WebDriver)GrapheneProxy.getProxyForHandler(this.handler, context.getWebDriver(new Class[0]).getClass(), interfaces);
        }

        protected GrapheneContext getContext(boolean exception) {
            GrapheneContext context = null;
            if (this.qualifier.equals(Default.class)) {
                try {
                    context = (GrapheneContext)CURRENT_CONTEXT.get();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (context == null || context.equals((Object)this)) {
                context = (GrapheneContext)((Map)ALL_CONTEXTS.get()).get(this.qualifier);
            }
            if (context == null && exception) {
                throw new IllegalStateException("There is no context available for qualifier " + this.qualifier.getName() + ". Available contexts are " + ((Map)ALL_CONTEXTS.get()).keySet() + ".");
            }
            return context;
        }

        protected GrapheneProxy.FutureTarget getFutureTarget() {
            return new GrapheneProxy.FutureTarget(){

                @Override
                public Object getTarget() {
                    return this.getContext(true).getWebDriver(new Class[0]);
                }
            };
        }
    }

    static class StaticInterfaceImplementation
    implements GrapheneContext.StaticInterface {
        StaticInterfaceImplementation() {
        }

        public GrapheneContext lastContext() {
            return (GrapheneContext)CURRENT_CONTEXT.getLast();
        }

        public GrapheneContext getContextFor(Class<?> qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException("The parameter 'qualifer' is null.");
            }
            LazyContext context = (LazyContext)((Object)((Map)LAZY_CONTEXTS.get()).get(qualifier));
            if (context == null) {
                try {
                    context = new LazyContext(qualifier, new BrowserActions(qualifier.getName()));
                    context.handler = GrapheneContextualHandler.forFuture(context, context.getFutureTarget());
                    GrapheneProxyInstance proxy = (GrapheneProxyInstance)context.getWebDriver(new Class[0]);
                    proxy.registerInterceptor(new SearchContextInterceptor());
                    proxy.registerInterceptor(new StaleElementInterceptor());
                    context.installatorProvider = new RemotePageExtensionInstallatorProvider(context.registry, (JavascriptExecutor)context.getWebDriver(JavascriptExecutor.class));
                    final LazyContext finalContext = context;
                    context.getBrowserActions().performAction(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            CURRENT_CONTEXT.set(finalContext);
                            return null;
                        }
                    });
                    ((Map)LAZY_CONTEXTS.get()).put(qualifier, context);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can't create a lazy context for " + qualifier.getName() + " qualifier.", e);
                }
            }
            return context;
        }

        public GrapheneContext setContextFor(GrapheneConfiguration configuration, WebDriver driver, Class<?> qualifier) {
            GrapheneContextImpl grapheneContext = new GrapheneContextImpl(configuration, driver, qualifier);
            ((Map)ALL_CONTEXTS.get()).put(qualifier, grapheneContext);
            return this.getContextFor(qualifier);
        }

        public void removeContextFor(Class<?> qualifier) {
            GrapheneContext context = (GrapheneContext)((Map)LAZY_CONTEXTS.get()).get(qualifier);
            if (context != null) {
                try {
                    ((LazyContext)context).getBrowserActions().performAction(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            CURRENT_CONTEXT.remove();
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((Map)LAZY_CONTEXTS.get()).remove(qualifier);
            }
            ((Map)ALL_CONTEXTS.get()).remove(qualifier);
        }
    }
}

