/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.findby.FindByUtilities;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class WebElementWrapperEnricher
extends AbstractSearchContextEnricher {
    @Inject
    private Instance<GrapheneConfiguration> configuration;

    public WebElementWrapperEnricher() {
    }

    public WebElementWrapperEnricher(Instance<GrapheneConfiguration> configuration) {
        this.configuration = configuration;
    }

    public void enrich(SearchContext searchContext, Object target) {
        List<Field> fields = FindByUtilities.getListOfFieldsAnnotatedWithFindBys(target);
        for (Field field : fields) {
            try {
                By rootBy;
                SearchContext localSearchContext;
                GrapheneContext grapheneContext;
                if (this.isValidClass(field.getType())) {
                    Object wrapper;
                    GrapheneContext grapheneContext2 = grapheneContext = searchContext == null ? null : ((GrapheneProxyInstance)searchContext).getGrapheneContext();
                    if (grapheneContext == null) {
                        grapheneContext = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(field.getAnnotations()));
                        localSearchContext = grapheneContext.getWebDriver(new Class[]{SearchContext.class});
                    } else {
                        localSearchContext = searchContext;
                    }
                    rootBy = FindByUtilities.getCorrectBy(field, ((GrapheneConfiguration)this.configuration.get()).getDefaultElementLocatingStrategy());
                    try {
                        Class<?> type = field.getType();
                        wrapper = this.createWrapper(grapheneContext, type, WebElementUtils.findElementLazily(rootBy, localSearchContext));
                    }
                    catch (Exception e) {
                        throw new GrapheneTestEnricherException("Can't instantiate element wrapper " + target.getClass() + "." + field.getName() + " of type " + field.getType(), e);
                    }
                    try {
                        WebElementWrapperEnricher.setValue(field, target, wrapper);
                        continue;
                    }
                    catch (Exception e) {
                        throw new GrapheneTestEnricherException("Can't set a value to the " + target.getClass() + "." + field.getName() + ".", e);
                    }
                }
                if (!field.getType().isAssignableFrom(List.class) || !this.isValidClass(this.getListType(field))) continue;
                GrapheneContext grapheneContext3 = grapheneContext = searchContext == null ? null : ((GrapheneProxyInstance)searchContext).getGrapheneContext();
                if (grapheneContext == null) {
                    grapheneContext = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(field.getAnnotations()));
                    localSearchContext = grapheneContext.getWebDriver(new Class[]{SearchContext.class});
                } else {
                    localSearchContext = searchContext;
                }
                rootBy = FindByUtilities.getCorrectBy(field, ((GrapheneConfiguration)this.configuration.get()).getDefaultElementLocatingStrategy());
                try {
                    Class<?> type = this.getListType(field);
                    List<?> wrappers = this.createWrappers(grapheneContext, type, WebElementUtils.findElementsLazily(rootBy, localSearchContext));
                    WebElementWrapperEnricher.setValue(field, target, wrappers);
                }
                catch (Exception e) {
                    throw new GrapheneTestEnricherException("Can't set a value to the " + target.getClass() + "." + field.getName() + ".", e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public Object[] resolve(SearchContext searchContext, Method method, Object[] resolvedParams) {
        return resolvedParams;
    }

    protected <T> T createWrapper(GrapheneContext grapheneContext, final Class<T> type, final WebElement element) throws Exception {
        Object wrapper = GrapheneProxy.getProxyForHandler(GrapheneContextualHandler.forFuture(grapheneContext, new GrapheneProxy.FutureTarget(){

            @Override
            public Object getTarget() {
                try {
                    return AbstractSearchContextEnricher.instantiate(type, element);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can't instantiate the " + type, e);
                }
            }
        }), type, new Class[0]);
        return wrapper;
    }

    protected <T> List<T> createWrappers(GrapheneContext grapheneContext, final Class<T> type, final List<WebElement> elements) {
        List wrapper = (List)GrapheneProxy.getProxyForHandler(GrapheneContextualHandler.forFuture(grapheneContext, new GrapheneProxy.FutureTarget(){

            @Override
            public Object getTarget() {
                try {
                    ArrayList target = new ArrayList();
                    for (WebElement element : elements) {
                        target.add(AbstractSearchContextEnricher.instantiate(type, element));
                    }
                    return target;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can't instantiate the " + type, e);
                }
            }
        }), List.class, new Class[0]);
        return wrapper;
    }

    protected final boolean isValidClass(Class<?> clazz) {
        Class<?> outerClass = clazz.getDeclaringClass();
        if (outerClass == null || Modifier.isStatic(clazz.getModifiers())) {
            if (clazz.equals(GrapheneElement.class)) {
                return true;
            }
            return ReflectionHelper.hasConstructor(clazz, WebElement.class);
        }
        return ReflectionHelper.hasConstructor(clazz, outerClass, WebElement.class);
    }

    public int getPrecedence() {
        return 1;
    }
}

