/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.PageObjectEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.location.ContextRootStore;
import org.jboss.arquillian.graphene.location.SecurityActions;
import org.jboss.arquillian.graphene.page.InitialPage;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.spi.location.LocationDecider;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationEnricher
implements TestEnricher {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<ContextRootStore> locationStore;
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<GrapheneConfiguration> configuration;

    public void enrich(Object testCase) {
    }

    public Object[] resolve(Method method) {
        int indexOfInitialPage = this.getIndexOfParameterWithAnnotation(InitialPage.class, method);
        if (indexOfInitialPage == -1) {
            return new Object[method.getParameterTypes().length];
        }
        Class<?> qualifier = ReflectionHelper.getQualifier(method.getParameterAnnotations()[indexOfInitialPage]);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] result = new Object[method.getParameterTypes().length];
        result[indexOfInitialPage] = this.goTo(parameterTypes[indexOfInitialPage], qualifier);
        return result;
    }

    public <T> T goTo(Class<T> pageObject, Class<?> browserQualifier) {
        T result = null;
        GrapheneContext grapheneContext = GrapheneContext.getContextFor(browserQualifier);
        WebDriver browser = grapheneContext.getWebDriver(new Class[0]);
        try {
            result = (T)PageObjectEnricher.setupPage(grapheneContext, (SearchContext)browser, pageObject);
        }
        catch (Exception e) {
            throw new GrapheneTestEnricherException("Error while initializing: " + pageObject, e);
        }
        this.handleLocationOf(pageObject, browser);
        return result;
    }

    private void handleLocationOf(Class<?> pageObjectClass, WebDriver browser) {
        Location location = pageObjectClass.getAnnotation(Location.class);
        if (location == null) {
            throw new IllegalArgumentException(String.format("The page object '%s' that you are navigating to using either Graphene.goTo(<page_object>) or @InitialPage is not annotated with @Location", pageObjectClass.getSimpleName()));
        }
        if (location.scheme() == null) {
            throw new IllegalArgumentException("Scheme for provided @Location can not be a null object.");
        }
        Class schemeClass = null;
        String defaultSchemeString = ((GrapheneConfiguration)this.configuration.get()).getScheme();
        try {
            if (defaultSchemeString != null) {
                schemeClass = SecurityActions.newInstance(defaultSchemeString);
            }
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (schemeClass == null) {
            schemeClass = location.scheme();
        }
        ((Injector)this.injector.get()).inject(this.locationStore.get());
        LocationDecider decider = this.resolveDecider(((ServiceLoader)this.serviceLoader.get()).all(LocationDecider.class), schemeClass);
        if (decider == null) {
            throw new UnsupportedOperationException(String.format("There is not any registered location decider which can decide '%s' scheme.", location.scheme().toString()));
        }
        browser.get(decider.decide(location.value()));
    }

    private int getIndexOfParameterWithAnnotation(Class<? extends Annotation> annotation, Method method) {
        int result;
        Annotation[][] annotationsOfAllParameters = method.getParameterAnnotations();
        boolean founded = false;
        for (result = 0; result < annotationsOfAllParameters.length; ++result) {
            for (int j = 0; j < annotationsOfAllParameters[result].length; ++j) {
                if (!annotationsOfAllParameters[result][j].annotationType().equals(annotation)) continue;
                founded = true;
                break;
            }
            if (founded) break;
        }
        if (!founded) {
            return -1;
        }
        return result;
    }

    private LocationDecider resolveDecider(Collection<LocationDecider> deciders, Class<?> scheme) {
        for (LocationDecider decider : deciders) {
            if (!decider.canDecide().getClass().equals(scheme)) continue;
            return decider;
        }
        return null;
    }
}

