/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.attribute;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.AttributeIsPresent;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueContains;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueEquals;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatorAttributeConditionFactory
extends AbstractBooleanConditionFactory<AttributeConditionFactory>
implements AttributeConditionFactory {
    private final SearchContext searchContext;
    private final By locator;
    private final String attribute;
    protected static final Logger LOGGER = Logger.getLogger(LocatorAttributeConditionFactory.class.getName());

    public LocatorAttributeConditionFactory(SearchContext searchContext, By locator, String attribute) {
        this.locator = locator;
        this.attribute = attribute;
        this.searchContext = searchContext;
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return new AttributeIsPresent(LocatorAttributeConditionFactory.this.findElement(LocatorAttributeConditionFactory.this.locator, driver), LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.getNegation()).apply(driver);
            }

            public String toString() {
                return String.format("attribute ('%s')%s to be present in element %s", LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.getNegation() ? " not" : "", LocatorAttributeConditionFactory.this.locator.toString());
            }
        };
    }

    @Override
    public ExpectedCondition<Boolean> contains(final String expected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return new AttributeValueContains(LocatorAttributeConditionFactory.this.findElement(LocatorAttributeConditionFactory.this.locator, driver), LocatorAttributeConditionFactory.this.attribute, expected, LocatorAttributeConditionFactory.this.getNegation()).apply(driver);
            }

            public String toString() {
                return String.format("text ('%s')%s to be contained by value of attribute ('%s') in element %s", expected, LocatorAttributeConditionFactory.this.getNegation() ? " not" : "", LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.locator.toString());
            }
        };
    }

    @Override
    public ExpectedCondition<Boolean> equalTo(final String expected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return new AttributeValueEquals(LocatorAttributeConditionFactory.this.findElement(LocatorAttributeConditionFactory.this.locator, driver), LocatorAttributeConditionFactory.this.attribute, expected, LocatorAttributeConditionFactory.this.getNegation()).apply(driver);
            }

            public String toString() {
                return String.format("text ('%s')%s to be equal to value of attribute ('%s') in element %s", expected, LocatorAttributeConditionFactory.this.getNegation() ? " not" : "", LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.locator.toString());
            }
        };
    }

    @Override
    protected AttributeConditionFactory copy() {
        return new LocatorAttributeConditionFactory(this.searchContext, this.locator, this.attribute);
    }

    protected WebElement findElement(By by, WebDriver driver) {
        try {
            return (this.searchContext == null ? driver : this.searchContext).findElement(by);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            LOGGER.log(Level.FINE, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }
}

