/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.util.List;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.InFrameInterceptor;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.page.InFrame;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.SearchContext;

public class InFrameEnricher
extends AbstractSearchContextEnricher {
    public void enrich(SearchContext searchContext, Object objectToEnrich) {
        List<Field> inFrameFields = ReflectionHelper.getFieldsWithAnnotation(objectToEnrich.getClass(), InFrame.class);
        for (Field field : inFrameFields) {
            boolean isAccessible = field.isAccessible();
            if (!isAccessible) {
                field.setAccessible(true);
            }
            InFrame inFrame = field.getAnnotation(InFrame.class);
            int index = inFrame.index();
            String nameOrId = inFrame.nameOrId();
            this.checkInFrameParameters(field, index, nameOrId);
            try {
                this.registerInFrameInterceptor(objectToEnrich, field, index, nameOrId);
            }
            catch (IllegalArgumentException e) {
                throw new GrapheneTestEnricherException("Only org.openqa.selenium.WebElement, Page fragments fields and Page Object fields can be annotated with @InFrame. Check the field: " + field + " declared in the class: " + objectToEnrich.getClass(), e);
            }
            catch (Exception e) {
                throw new GrapheneTestEnricherException(e);
            }
            if (isAccessible) continue;
            field.setAccessible(false);
        }
    }

    private void registerInFrameInterceptor(Object objectToEnrich, Field field, int index, String nameOrId) throws IllegalAccessException, ClassNotFoundException {
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)field.get(objectToEnrich);
        if (index != -1) {
            proxy.registerInterceptor(new InFrameInterceptor(index));
        } else {
            proxy.registerInterceptor(new InFrameInterceptor(nameOrId));
        }
    }

    private void checkInFrameParameters(Field field, int index, String nameOrId) {
        if (nameOrId.trim().equals("") && index < 0) {
            throw new GrapheneTestEnricherException("You have to provide either non empty nameOrId or non negative index value of the frame/iframe in the @InFrame. Check field " + field + " declared in: " + field.getDeclaringClass());
        }
    }

    public int getPrecedence() {
        return 0;
    }
}

