/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import java.util.Collection;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.GraphenePageExtensionsContext;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistryImpl;
import org.jboss.arquillian.graphene.page.extension.RemotePageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.spi.page.PageExtensionProvider;
import org.jboss.arquillian.graphene.spi.page.PageExtensionsCleaned;
import org.jboss.arquillian.graphene.spi.page.PageExtensionsReady;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.openqa.selenium.JavascriptExecutor;

public class GraphenePageExtensionRegistrar {
    @Inject
    @ClassScoped
    private InstanceProducer<PageExtensionRegistry> pageExtensionRegistry;
    @Inject
    @ClassScoped
    private InstanceProducer<PageExtensionInstallatorProvider> pageExtensionInstallatorProvider;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<PageExtensionsReady> pageExtensionsReady;
    @Inject
    private Event<PageExtensionsCleaned> pageExtensionsCleaned;

    public void registerPageExtensionRegistry(@Observes BeforeClass event, TestClass testClass) {
        this.pageExtensionRegistry.set((Object)new PageExtensionRegistryImpl());
        this.loadPageExtensions(testClass);
        GraphenePageExtensionsContext.setRegistry((PageExtensionRegistry)this.pageExtensionRegistry.get());
        this.pageExtensionInstallatorProvider.set((Object)new RemotePageExtensionInstallatorProvider((PageExtensionRegistry)this.pageExtensionRegistry.get(), (JavascriptExecutor)GrapheneContext.getProxyForInterfaces(JavascriptExecutor.class)));
        GraphenePageExtensionsContext.setInstallatorProvider((PageExtensionInstallatorProvider)this.pageExtensionInstallatorProvider.get());
        this.pageExtensionsReady.fire((Object)new PageExtensionsReady());
    }

    public void unregisterPageExtensionRegistry(@Observes AfterClass event) {
        ((PageExtensionRegistry)this.pageExtensionRegistry.get()).flush();
        GraphenePageExtensionsContext.reset();
        this.pageExtensionsCleaned.fire((Object)new PageExtensionsCleaned());
    }

    protected void loadPageExtensions(TestClass testClass) {
        Collection providers = ((ServiceLoader)this.serviceLoader.get()).all(PageExtensionProvider.class);
        for (PageExtensionProvider provider : providers) {
            ((PageExtensionRegistry)this.pageExtensionRegistry.get()).register(provider.getPageExtensions(testClass));
        }
    }
}

