/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.integration;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.drone.spi.Enhancer;
import org.jboss.arquillian.drone.webdriver.spi.DroneAugmented;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrapheneEnhancer
implements Enhancer<WebDriver> {
    public int getPrecedence() {
        return -100;
    }

    public boolean canEnhance(Class<?> type, Class<? extends Annotation> qualifier) {
        return WebDriver.class.isAssignableFrom(type);
    }

    public WebDriver enhance(WebDriver driver, Class<? extends Annotation> qualifier) {
        GrapheneContext.set(driver);
        Class<?> baseDriverClass = driver.getClass();
        if (driver instanceof DroneAugmented) {
            baseDriverClass = ((DroneAugmented)driver).getWrapped().getClass();
        }
        Class<?>[] interfaces = GrapheneProxyUtil.getInterfaces(driver.getClass());
        Object proxy = GrapheneContext.getProxyForDriver(baseDriverClass, interfaces);
        return proxy;
    }

    public WebDriver deenhance(WebDriver instance, Class<? extends Annotation> qualifier) {
        if (instance instanceof GrapheneProxyInstance) {
            instance = (WebDriver)((GrapheneProxyInstance)instance).unwrap();
        }
        GrapheneContext.reset();
        return instance;
    }
}

