/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.locator;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.BooleanConditionWrapper;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.arquillian.graphene.condition.StringConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.LocatorAttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.locator.LocatorElementTextConditionFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementLocatorConditionFactory
extends AbstractBooleanConditionFactory<ElementConditionFactory>
implements ElementConditionFactory {
    private final By locator;
    protected static final Logger LOGGER = Logger.getLogger(ElementLocatorConditionFactory.class.getName());

    public ElementLocatorConditionFactory(By locator) {
        if (locator == null) {
            throw new IllegalArgumentException("The locator can't be null.");
        }
        this.locator = locator;
    }

    @Override
    public ExpectedCondition<Boolean> isVisible() {
        return new BooleanConditionWrapper(ExpectedConditions.visibilityOfElementLocated((By)this.locator), this.getNegation(), NoSuchElementException.class);
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new BooleanConditionWrapper(ExpectedConditions.presenceOfElementLocated((By)this.locator), this.getNegation(), NoSuchElementException.class);
    }

    @Override
    public ExpectedCondition<Boolean> isSelected() {
        return ExpectedConditions.elementSelectionStateToBe((By)this.locator, (!this.getNegation() ? 1 : 0) != 0);
    }

    public StringConditionFactory text() {
        return this.getNegation() ? (StringConditionFactory)new LocatorElementTextConditionFactory(this.locator).not() : new LocatorElementTextConditionFactory(this.locator);
    }

    @Override
    public ExpectedCondition<Boolean> textContains(String expected) {
        return this.text().contains(expected);
    }

    @Override
    public ExpectedCondition<Boolean> textEquals(final String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("The expected string is null.");
        }
        return new BooleanConditionWrapper(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String elementText = ElementLocatorConditionFactory.findElement(ElementLocatorConditionFactory.this.locator, driver).getText();
                return expected.equals(elementText);
            }

            public String toString() {
                return String.format("text ('%s') to be equal to text  in element found by %s", expected, ElementLocatorConditionFactory.this.locator);
            }
        }, this.getNegation(), new Class[0]);
    }

    @Override
    protected ElementConditionFactory copy() {
        ElementLocatorConditionFactory copy = new ElementLocatorConditionFactory(this.locator);
        copy.setNegation(this.getNegation());
        return copy;
    }

    @Override
    public AttributeConditionFactory attribute(String attribute) {
        return new LocatorAttributeConditionFactory(this.locator, attribute);
    }

    private static WebElement findElement(By by, WebDriver driver) {
        try {
            return driver.findElement(by);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            LOGGER.log(Level.FINE, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }
}

