/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import java.lang.reflect.Modifier;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.javascript.ClassImposterizer;
import org.jboss.arquillian.graphene.javascript.JSInterfaceHandler;
import org.jboss.arquillian.graphene.javascript.JSTarget;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSInterfaceFactory<T> {
    private JSInterfaceHandler handler;

    private JSInterfaceFactory(WebDriver driver, Class<T> jsInterface) {
        if (!jsInterface.isInterface() && !Modifier.isAbstract(jsInterface.getModifiers())) {
            throw new IllegalArgumentException("interface or abstract class must be provided :" + jsInterface);
        }
        this.handler = new JSInterfaceHandler(driver, new JSTarget(jsInterface));
    }

    public static <T> T create(Class<T> jsInterface) {
        return JSInterfaceFactory.create((WebDriver)GrapheneContext.getProxyForInterfaces(JavascriptExecutor.class), jsInterface);
    }

    public static <T> T create(WebDriver driver, Class<T> jsInterface) {
        return new JSInterfaceFactory<T>(driver, jsInterface).instantiate();
    }

    public T instantiate() {
        Class<?> jsInterface = this.handler.getTarget().getInterface();
        return (T)ClassImposterizer.INSTANCE.imposterise(this.handler, jsInterface, new Class[0]);
    }
}

