/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.enricher.AbstractWebElementEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.PageFragmentInitializationException;
import org.jboss.arquillian.graphene.enricher.findby.FindByUtilities;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.spi.annotations.Root;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFragmentEnricher
extends AbstractWebElementEnricher {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void enrich(SearchContext searchContext, Object target) {
        List<Field> fields = FindByUtilities.getListOfFieldsAnnotatedWithFindBys(target);
        for (Field field : fields) {
            if (this.isPageFragmentClass(field.getType())) {
                this.setupPageFragment(searchContext, target, field);
                continue;
            }
            try {
                if (!field.getType().isAssignableFrom(List.class) || !this.isPageFragmentClass(this.getListType(field))) continue;
                this.setupPageFragmentList(searchContext, target, field);
            }
            catch (ClassNotFoundException e) {
                throw new PageFragmentInitializationException(e.getMessage(), e);
            }
        }
    }

    protected final boolean isPageFragmentClass(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isFinal(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers());
    }

    protected final <T> List<T> createPageFragmentList(final Class<T> clazz, final SearchContext searchContext, final By rootBy) {
        List result = (List)GrapheneProxy.getProxyForFutureTarget(new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                List elements = searchContext.findElements(rootBy);
                ArrayList fragments = new ArrayList();
                for (int i = 0; i < elements.size(); ++i) {
                    fragments.add(PageFragmentEnricher.this.createPageFragment(clazz, PageFragmentEnricher.this.createWebElement(rootBy, searchContext, i)));
                }
                return fragments;
            }
        }, List.class, new Class[0]);
        return result;
    }

    protected final <T> T createPageFragment(Class<T> clazz, WebElement root) {
        try {
            T pageFragment = this.instantiate(clazz);
            List<Field> roots = ReflectionHelper.getFieldsWithAnnotation(clazz, Root.class);
            if (roots.size() > 1) {
                throw new PageFragmentInitializationException("The Page Fragment " + NEW_LINE + pageFragment.getClass() + NEW_LINE + " can not have more than one field annotated with Root annotation!" + "Your fields with @Root annotation: " + roots + NEW_LINE);
            }
            if (roots.size() == 1) {
                this.setValue(roots.get(0), pageFragment, root);
            }
            this.enrichRecursively((SearchContext)root, pageFragment);
            return pageFragment;
        }
        catch (NoSuchMethodException ex) {
            throw new PageFragmentInitializationException(" Check whether declared Page Fragment has no argument constructor!", ex);
        }
        catch (IllegalAccessException ex) {
            throw new PageFragmentInitializationException(" Check whether declared Page Fragment has public no argument constructor!", ex);
        }
        catch (InstantiationException ex) {
            throw new PageFragmentInitializationException(" Check whether you did not declare Page Fragment with abstract type!", ex);
        }
        catch (Exception ex) {
            throw new PageFragmentInitializationException(ex);
        }
    }

    protected final void setupPageFragmentList(SearchContext searchContext, Object target, Field field) throws ClassNotFoundException {
        By rootBy = FindByUtilities.getCorrectBy(field);
        if (rootBy == null) {
            throw new PageFragmentInitializationException("Your declaration of Page Fragment in test " + field.getDeclaringClass().getName() + " is annotated with @FindBy without any " + "parameters, in other words without reference to root of the particular Page Fragment on the page!" + NEW_LINE);
        }
        List<?> pageFragments = this.createPageFragmentList(this.getListType(field), searchContext, rootBy);
        this.setValue(field, target, pageFragments);
    }

    protected final void setupPageFragment(SearchContext searchContext, Object target, Field field) {
        By rootBy = FindByUtilities.getCorrectBy(field);
        if (rootBy == null) {
            throw new PageFragmentInitializationException("Your declaration of Page Fragment in test " + field.getDeclaringClass().getName() + " is annotated with @FindBy without any " + "parameters, in other words without reference to root of the particular Page Fragment on the page!" + NEW_LINE);
        }
        WebElement root = this.createWebElement(rootBy, searchContext);
        Object pageFragment = this.createPageFragment(field.getType(), root);
        this.setValue(field, target, pageFragment);
    }
}

