/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.guard;

import org.jboss.arquillian.graphene.guard.RequestGuard;
import org.jboss.arquillian.graphene.guard.RequestGuardException;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.page.RequestType;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestGuardFactory {
    public static <T> T guard(T target, final RequestType requestExpected) {
        if (requestExpected == null) {
            throw new IllegalArgumentException("The paremeter [requestExpected] is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("The paremeter [target] is null.");
        }
        GrapheneProxyInstance proxy = GrapheneProxy.isProxyInstance(target) ? (GrapheneProxyInstance)((GrapheneProxyInstance)target).copy() : (GrapheneProxyInstance)GrapheneProxy.getProxyForTarget(target);
        proxy.registerInterceptor(new Interceptor(){

            public Object intercept(InvocationContext context) throws Throwable {
                RequestGuard guard = JSInterfaceFactory.create(RequestGuard.class);
                guard.clearRequestDone();
                Object result = context.invoke();
                if (!guard.getRequestDone().equals((Object)requestExpected)) {
                    throw new RequestGuardException(requestExpected, guard.getRequestDone());
                }
                return result;
            }
        });
        return (T)proxy;
    }
}

