/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.Factory;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.spi.annotations.Page;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.openqa.selenium.By;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFragmentsEnricher
implements TestEnricher {
    private static final String FIND_BY_ANNOTATION = "org.openqa.selenium.support.FindBy";
    private static final String PAGE_ANNOTATION = "org.jboss.arquillian.graphene.spi.annotations.Page";

    public void enrich(Object testCase) {
        if (ReflectionHelper.isClassPresent(FIND_BY_ANNOTATION)) {
            this.initFieldsAnnotatedByFindBy(testCase);
        }
        if (ReflectionHelper.isClassPresent(PAGE_ANNOTATION)) {
            List<Field> fields = ReflectionHelper.getFieldsWithAnnotation(testCase.getClass(), Page.class);
            this.initializePageObjectFields(testCase, fields);
        }
    }

    private void initFieldsAnnotatedByFindBy(Object object) {
        List<Field> fields = ReflectionHelper.getFieldsWithAnnotation(object.getClass(), FindBy.class);
        ArrayList<Field> copy = new ArrayList<Field>();
        copy.addAll(fields);
        fields = this.removePlainFindBy(fields);
        this.initPageFragmentsFields(fields, object);
        copy.removeAll(fields);
        this.initNotPageFragmentsFields(copy, object);
    }

    private void initializePageObjectFields(Object testCase, List<Field> fields) {
        for (Field i : fields) {
            try {
                Class<?> declaredClass = Class.forName(i.getGenericType().toString().split(" ")[1]);
                Object page = declaredClass.newInstance();
                this.initFieldsAnnotatedByFindBy(page);
                boolean accessible = i.isAccessible();
                if (!accessible) {
                    i.setAccessible(true);
                }
                i.set(testCase, page);
                if (accessible) continue;
                i.setAccessible(false);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can not initialise Page Object!");
            }
        }
    }

    private void initNotPageFragmentsFields(List<Field> fields, Object object) {
        for (Field i : fields) {
            FindBy findBy = i.getAnnotation(FindBy.class);
            By by = Factory.getReferencedBy(findBy);
            WebElement element = this.setUpTheProxy(by);
            this.setObjectToField(i, object, element);
        }
    }

    private void setObjectToField(Field field, Object objectWithField, Object object) {
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            field.set(objectWithField, object);
        }
        catch (Exception e) {
            throw new RuntimeException("The Page Fragment field can not be initialised!", e);
        }
        if (!accessible) {
            field.setAccessible(false);
        }
    }

    private WebElement setUpTheProxy(final By by) {
        WebElement e = (WebElement)GrapheneProxy.getProxyForFutureTarget(new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                WebDriver driver = (WebDriver)GrapheneContext.getProxyForInterfaces(HasInputDevices.class);
                WebElement root = driver.findElement(by);
                return root;
            }
        }, WebElement.class, new Class[0]);
        return e;
    }

    private void initPageFragmentsFields(List<Field> fields, Object object) {
        for (Field pageFragmentField : fields) {
            FindBy findBy = pageFragmentField.getAnnotation(FindBy.class);
            By by = Factory.getReferencedBy(findBy);
            WebElement rootElement = this.setUpTheProxy(by);
            Class<?> implementationClass = pageFragmentField.getType();
            Object pageFragment = Factory.initializePageFragment(implementationClass, rootElement);
            this.setObjectToField(pageFragmentField, object, pageFragment);
        }
    }

    private List<Field> removePlainFindBy(List<Field> findByFields) {
        Iterator<Field> i = findByFields.iterator();
        while (i.hasNext()) {
            Field field = i.next();
            Class<?> fieldType = field.getType();
            if (!fieldType.equals(WebElement.class)) continue;
            i.remove();
        }
        return findByFields;
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }
}

