/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrapheneContext {
    private static final ThreadLocal<WebDriver> REFERENCE = new ThreadLocal();
    private static GrapheneProxy.FutureTarget TARGET = new GrapheneProxy.FutureTarget(){

        public Object getTarget() {
            return GrapheneContext.get();
        }
    };

    private GrapheneContext() {
    }

    public static void set(WebDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("context instance can't be null");
        }
        if (GrapheneProxy.isProxyInstance(driver)) {
            throw new IllegalArgumentException("instance of the proxy can't be set to the context");
        }
        REFERENCE.set(driver);
    }

    public static void reset() {
        REFERENCE.set(null);
    }

    static WebDriver get() {
        WebDriver driver = REFERENCE.get();
        if (driver == null) {
            throw new NullPointerException("context is null - it needs to be setup before starting to use it");
        }
        return driver;
    }

    public static boolean isInitialized() {
        return REFERENCE.get() != null;
    }

    public static WebDriver getProxy() {
        return (WebDriver)GrapheneProxy.getProxyForFutureTarget(TARGET, null, WebDriver.class, JavascriptExecutor.class);
    }

    public static <T extends WebDriver> T getProxyForDriver(Class<T> webDriverImplClass) {
        return (T)((WebDriver)GrapheneProxy.getProxyForFutureTarget(TARGET, webDriverImplClass, new Class[0]));
    }

    public static <T> T getProxyForInterfaces(Class<?> ... interfaces) {
        Class<?>[] interfacesIncludingWebdriver = GrapheneProxyUtil.concatClasses(interfaces, WebDriver.class);
        return GrapheneProxy.getProxyForFutureTarget(TARGET, null, interfacesIncludingWebdriver);
    }

    public static boolean holdsInstanceOf(Class<?> clazz) {
        return clazz.isAssignableFrom(GrapheneContext.get().getClass());
    }
}

