/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import org.jboss.arquillian.ajocado.format.SimplifiedFormat;
import org.jboss.arquillian.core.spi.Validate;

public class ExtendedSelenium
extends DefaultSelenium {
    public ExtendedSelenium(CommandProcessor commandProcessor) {
        super(commandProcessor);
    }

    public void open(String url) {
        this.commandProcessor.doCommand("open", new String[]{url, "true"});
    }

    public String getStyle(String locator, String property) {
        return this.commandProcessor.getString("getStyle", new String[]{locator, property});
    }

    public void scrollIntoView(String locator, String alignToTop) {
        this.commandProcessor.doCommand("scrollIntoView", new String[]{locator, alignToTop});
    }

    public void mouseOverAt(String locator, String coordString) {
        this.commandProcessor.doCommand("mouseOverAt", new String[]{locator, coordString});
    }

    public void mouseOutAt(String locator, String coordString) {
        this.commandProcessor.doCommand("mouseOutAt", new String[]{locator, coordString});
    }

    public boolean belongsClass(String locator, String className) {
        Validate.notNull((Object)"className should not be null", (String)className);
        Validate.notNull((Object)"locator should not be null", (String)locator);
        String classLocator = SimplifiedFormat.format((String)"{0}@class", (Object[])new Object[]{locator});
        String classNames = this.getAttribute(classLocator);
        String regex = SimplifiedFormat.format((String)"(?:^|.*\\s){0}(?:$|\\s.*)", (Object[])new Object[]{className});
        return classNames.matches(regex);
    }

    public boolean isAttributePresent(String elementLocator, String attributeName) {
        return this.commandProcessor.getBoolean("isAttributePresent", new String[]{elementLocator, attributeName});
    }

    public Number getJQueryCount(String jqueryLocator) {
        return this.commandProcessor.getNumber("getJQueryCount", new String[]{jqueryLocator});
    }

    public void doCommand(String command, String param1, String param2) {
        String[] array = new String[]{param1, param2};
        if (param2 == null) {
            array = new String[]{param1};
        }
        this.commandProcessor.doCommand(command, array);
    }
}

