/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.ajax;

import com.thoughtworks.selenium.SeleniumException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.waiting.DefaultWaiting;
import org.jboss.arquillian.ajocado.waiting.ajax.AjaxWaiting;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAjaxWaiting
extends DefaultWaiting<AjaxWaiting>
implements AjaxWaiting {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();

    @Override
    public void until(JavaScriptCondition condition) {
        this.waitExpectingTimeout(condition.getJavaScriptCondition());
    }

    @Override
    public <T> void waitForChange(T oldValue, JavaScriptRetriever<T> retriever) {
        JavaScript condition = this.prepareCondition(oldValue, retriever);
        this.waitExpectingTimeout(condition);
    }

    @Override
    public <T> void waitForChange(JavaScriptRetriever<T> retriever) {
        Object retrieved = this.waitForChangeAndReturn(retriever.getValue(), retriever);
        retriever.setValue(retrieved);
    }

    @Override
    public <T> T waitForChangeAndReturn(T oldValue, JavaScriptRetriever<T> retriever) {
        JavaScript script = retriever.getJavaScriptRetrieve();
        JavaScript condition = this.prepareCondition(oldValue, retriever);
        this.waitExpectingTimeout(condition);
        String retrieved = this.selenium.getEval(script);
        T converted = retriever.getConvertor().backwardConversion(retrieved);
        return converted;
    }

    @Override
    public <T> T waitForChangeAndReturn(JavaScriptRetriever<T> retriever) {
        Object retrieved = this.waitForChangeAndReturn(retriever.getValue(), retriever);
        retriever.setValue(retrieved);
        return retrieved;
    }

    private <T> JavaScript prepareCondition(T oldValue, JavaScriptRetriever<T> retriever) {
        String scriptString = retriever.getJavaScriptRetrieve().getAsString();
        String oldValueString = retriever.getConvertor().forwardConversion(oldValue);
        String escapedOldValueString = StringEscapeUtils.escapeEcmaScript((String)oldValueString);
        return JavaScript.js((String)"{0} != '{1}'").parametrize(new Object[]{scriptString, escapedOldValueString});
    }

    private void waitExpectingTimeout(JavaScript condition) {
        try {
            this.selenium.waitForCondition(condition, this.getTimeout());
        }
        catch (SeleniumException e) {
            if (this.isTimeoutException(e)) {
                this.fail();
                return;
            }
            throw e;
        }
    }

    private boolean isTimeoutException(SeleniumException e) {
        return e.getMessage().startsWith("Timed out after");
    }
}

